#pragma once

#include <util/generic/vector.h>
#include <util/generic/string.h>

namespace NLSA {
    class IProjector {
    public:
        [[nodiscard]] virtual TVector <TString> Apply(const TVector <TString> &words) const = 0;

        [[nodiscard]] virtual const TString &GetRepresentation() const = 0;

        virtual ~IProjector() = default;
    };
}
