#pragma once

#include <util/generic/string.h>
#include "projector.h"

namespace NLSA {
    class TSegmentProjector: public IProjector {
        static const constexpr TStringBuf NAME = "segment";

    public:
        static bool Accept(const TStringBuf& funcName) noexcept;
        static TSimpleSharedPtr<const TSegmentProjector> Make(const TStringBuf& args);

        explicit TSegmentProjector(size_t size, size_t overlap, size_t maxLen) noexcept;

        [[nodiscard]] size_t GetSize() const;

        [[nodiscard]] size_t GetOverlap() const;

        [[nodiscard]] size_t GetMaxLen() const;

        [[nodiscard]] TVector<TString> Apply(const TVector<TString>& words) const override;

        [[nodiscard]] const TString& GetRepresentation() const override;

    private:
        size_t Size, Overlap, MaxLen;
        TString Represantation;
    };
}
