#include "abook.h"
#include "gc.h"

namespace NLua {


    int TAbookInfo::SentCount(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.SentCount);
        return 1;
    }

    int TAbookInfo::ReceivedCount(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.ReceivedCount);
        return 1;
    }

    int TAbookInfo::ReceivedReadCount(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.ReceivedReadCount);
        return 1;
    }

    int TAbookInfo::DomainReceivedCount(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.DomainReceivedCount);
        return 1;
    }

    int TAbookInfo::DomainReceivedReadCount(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.DomainReceivedReadCount);
        return 1;
    }

    int TAbookInfo::TimesContacted(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.TimesContacted);
        return 1;
    }

    int TAbookInfo::SourceType(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.SourceType);
        return 1;
    }

    TAbookInfo::TAbookInfo(const NHtmlSanMisc::TAbookInfo &base) noexcept: Base(base) {}

    const luaL_Reg TAbookInfo::LUA_FUNCTIONS[] = {
            {"sent_count",                 NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::SentCount>},
            {"received_count",             NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::ReceivedCount>},
            {"received_read_count",        NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::ReceivedReadCount>},
            {"domain_received_count",      NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::DomainReceivedCount>},
            {"domain_received_read_count", NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::DomainReceivedReadCount>},
            {"times_contacted",            NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::TimesContacted>},
            {"source_type",                NLua::MethodConstHandler<TAbookInfo, &TAbookInfo::SourceType>},
            {GC,                           NLua::Destructor<TAbookInfo>},
            {nullptr,                      nullptr}};

    const char TAbookInfo::LUA_METATABLE_NAME[] = "abook_mt";
}
