#pragma once

#include <mail/so/libs/html_sanitizer_misc/html_sanitizer_misc.h>
#include <library/cpp/lua/wrapper.h>
#include "context.h"

namespace NLua {
    class TAbookInfo {
    public:
        static const luaL_Reg LUA_FUNCTIONS[];
        static const char LUA_METATABLE_NAME[];

        int SentCount(TLuaStateHolder &state) const;
        int ReceivedCount(TLuaStateHolder &state) const;
        int ReceivedReadCount(TLuaStateHolder &state) const;
        int DomainReceivedCount(TLuaStateHolder &state) const;
        int DomainReceivedReadCount(TLuaStateHolder &state) const;
        int TimesContacted(TLuaStateHolder &state) const;
        int SourceType(TLuaStateHolder &state) const;

        explicit TAbookInfo(const NHtmlSanMisc::TAbookInfo &base) noexcept;

    private:
        const NHtmlSanMisc::TAbookInfo &Base;
    };
}
