#pragma once

#include <library/cpp/lua/wrapper.h>
#include <mail/so/libs/html_sanitizer_misc/html_sanitizer_misc.h>
#include "rule.h"
#include "kv_logger.h"

namespace NLua {
    class IRuleProvider {
    public:
        virtual const IRule& Get(const TStringBuf& ruleName) const = 0;
        virtual IRule& GetMutable(const TStringBuf& ruleName) = 0;
        virtual ~IRuleProvider() = default;
    };

    class IShinglerProvider {
    public:
        virtual TString CheckShingle(ui32 shingleType, const TStringBuf& text) = 0;
        virtual ~IShinglerProvider() = default;
    };


    class TContext {
    public:
        class TPtr {
        public:
            static const luaL_Reg LUA_FUNCTIONS[];
            static const char LUA_METATABLE_NAME[];

            int ActivateRule(TLuaStateHolder &state) const;
            int IsRuleActive(TLuaStateHolder &state) const;
            int GetRule(TLuaStateHolder &state) const;
            int MlLog(TLuaStateHolder &state) const;
            int DlvLog(TLuaStateHolder &state) const;
            int GetSo2Context(TLuaStateHolder &state) const;
            int AddType(TLuaStateHolder &state) const;
            int CheckShingle(TLuaStateHolder &state) const;

            explicit TPtr(TContext &base) noexcept;

        private:
            TContext &Base;
        };

    public:
        TContext() = default;
        explicit TContext(const NHtmlSanMisc::TAnswer* so2Answer,
                          IRuleProvider* ruleProvider,
                          IKVLogProvider* dlvLogProvider,
                          IKVLogProvider* mlLogProvider,
                          IShinglerProvider* shinglerProvider = {}) noexcept;
        TPtr AsPtr() &;
        void SetSo2Answer(const NHtmlSanMisc::TAnswer* so2Answer);
        void SetRuleProvider(IRuleProvider* ruleProvider);
        void SetDlvLogProvider(IKVLogProvider* logProvider);
        void SetMlLogProvider(IKVLogProvider* logProvider);
        void SetShinglerProvider(IShinglerProvider* shinglerProvider);
        [[nodiscard]] const TVector<TString>& GetTypes() const;
    private:
        const NHtmlSanMisc::TAnswer* So2Answer{};
        IRuleProvider* RuleProvider{};
        IKVLogProvider* DlvLogProvider{};
        IKVLogProvider* MlLogProvider{};
        IShinglerProvider* ShinglerProvider{};
        TVector<TString> Types;
    };
}
