
#include <library/cpp/lua/wrapper.h>
#include <mail/so/spamstop/tools/pcre_wrapper/pcre_wrapper.h>
#include <util/charset/utf8.h>
#include "gc.h"

struct TLuaPcre : TNonCopyable {
    const NRegexp::TPcre Re;
    static const NRegexp::TSettings Settings;

    explicit TLuaPcre(const TStringBuf &re) noexcept: Re(re, Settings) {}

    static int Compile(TLuaStateHolder &state) {
        state.require(1);

        const TStringBuf re = state.to_string(1);

        state.push_userdata<TLuaPcre>(re);
        return 1;
    }

    int Match(TLuaStateHolder &state) const {
        state.require(2);

        const TStringBuf text = state.to_string(2);
        const size_t limit = state.to_number(3, 0ul);

        NRegexp::TMatches matches;

        NRegexp::EMatchResult matchResult;
        if(limit > 0) {
            matchResult = Re.Match(text, limit, matches);
        } else {
            matchResult = Re.Match(text);
        }
        if (matchResult == NRegexp::EMatchResult::Match) {
            state.create_table();
            int index = 1;
            for (const TStringBuf &match: matches) {
                state.push_string(match);
                state.rawseti(-2, index++);
            }
            return 1;
        } else {
            return 0;
        }
    }

    static const luaL_Reg LUA_FUNCTIONS[];
    static const char LUA_METATABLE_NAME[];
};

const luaL_Reg TLuaPcre::LUA_FUNCTIONS[] = {
        {"match", NLua::MethodConstHandler<TLuaPcre, &TLuaPcre::Match>},
        {NLua::GC,  NLua::Destructor<TLuaPcre>},
        {nullptr, nullptr}};

const char TLuaPcre::LUA_METATABLE_NAME[] = "pcre_mt";

const NRegexp::TSettings TLuaPcre::Settings(CODES_UTF8);

namespace NLua {
    void BootstrapPcre(TLuaStateHolder &state) {
        state.register_function("pcre_compile", NLua::FunctionHandler<&TLuaPcre::Compile>);
    }

    void BootstrapPcre(TLuaStateHolder &&state) {
        BootstrapPcre(state);
    }
}

extern "C" int luaopen_pcre(lua_State *L) {
    NLua::BootstrapPcre(TLuaStateHolder(L));
    return 0;
}
