#include "personal_filter.h"
#include "gc.h"

namespace NLua {
    int TPersonalFilter::LastType(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.LastType);
        return 1;
    }

    int TPersonalFilter::Hams(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.Hams);
        return 1;
    }

    int TPersonalFilter::Spams(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base.Spams);
        return 1;
    }

    TPersonalFilter::TPersonalFilter(const NHtmlSanMisc::TPersonalFilter &base) noexcept: Base(base) {}

    const luaL_Reg TPersonalFilter::LUA_FUNCTIONS[] = {
            {"last_type", NLua::MethodConstHandler<TPersonalFilter, &TPersonalFilter::LastType>},
            {"hams",      NLua::MethodConstHandler<TPersonalFilter, &TPersonalFilter::Hams>},
            {"spams",     NLua::MethodConstHandler<TPersonalFilter, &TPersonalFilter::Spams>},
            {GC,          NLua::Destructor<TPersonalFilter>},
            {nullptr,     nullptr}};

    const char TPersonalFilter::LUA_METATABLE_NAME[] = "pf_mt";
}
