#include <library/cpp/lua/wrapper.h>
#include <mail/so/libs/syslog/so_log.h>


namespace NLua {
    static int print(TLuaStateHolder &state) {
        state.require(1);

        const TStringBuf message = state.to_string(1);

        Syslog(TLOG_INFO) << message;
        return 0;
    }

    void BootstrapPrint(TLuaStateHolder &state) {
        state.register_function("print", NLua::FunctionHandler<&print>);
    }
}