#include "rule.h"
#include "gc.h"

namespace NLua {
    int IRule::TPtr::Activate(TLuaStateHolder &state) {
        state.require(1);
        Base->Activate();
        return 0;
    }

    int IRule::TPtr::IsActive(TLuaStateHolder &state) const {
        state.require(1);
        state.push_bool(Base->IsActive());
        return 1;
    }

    int IRule::TPtr::SetScore(TLuaStateHolder &state) {
        state.require(2);
        Base->SetScore(state.to_number<double>(2));
        return 0;
    }

    int IRule::TPtr::GetScore(TLuaStateHolder &state) const {
        state.require(1);
        state.push_number(Base->GetScore());
        return 1;
    }

    int IRule::TPtr::AddScore(TLuaStateHolder &state) {
        state.require(2);
        const double newScore = Base->GetScore() + state.to_number<double>(2);
        Base->SetScore(newScore);
        state.push_number(Base->GetScore());
        return 1;
    }

    IRule::TPtr::TPtr(IRule *base) noexcept: Base(base) {}

    IRule::TPtr IRule::AsPtr() &{
        return TPtr(this);
    }

    const luaL_Reg IRule::TPtr::LUA_FUNCTIONS[] = {
            {"activate",  NLua::MethodHandler<IRule::TPtr, &IRule::TPtr::Activate>},
            {"is_active", NLua::MethodConstHandler<IRule::TPtr, &IRule::TPtr::IsActive>},
            {"set_score", NLua::MethodHandler<IRule::TPtr, &IRule::TPtr::SetScore>},
            {"get_score", NLua::MethodConstHandler<IRule::TPtr, &IRule::TPtr::GetScore>},
            {"add_score", NLua::MethodHandler<IRule::TPtr, &IRule::TPtr::AddScore>},
            {GC,          NLua::Destructor<IRule::TPtr>},
            {nullptr,     nullptr}};

    const char IRule::TPtr::LUA_METATABLE_NAME[] = "rule_mt";
}
