#pragma once

#include <library/cpp/lua/wrapper.h>

namespace NLua {
    class IRule {
    public:
        class TPtr {
        public:
            static const luaL_Reg LUA_FUNCTIONS[];
            static const char LUA_METATABLE_NAME[];

            int Activate(TLuaStateHolder &state);

            int IsActive(TLuaStateHolder &state) const;

            int SetScore(TLuaStateHolder &state);

            int GetScore(TLuaStateHolder &state) const;

            int AddScore(TLuaStateHolder &state);

            explicit TPtr(IRule *base) noexcept;

        private:
            IRule *Base;
        };

    public:
        virtual void Activate() = 0;

        [[nodiscard]] virtual bool IsActive() const = 0;

        virtual void SetScore(double score) = 0;

        [[nodiscard]] virtual double GetScore() const = 0;

        TPtr AsPtr() &;

        virtual ~IRule() = default;
    };
}