#pragma once

#include <library/cpp/json/json_value.h>
#include "context.h"

namespace NLua {
    class TRunner : TMoveOnly {
    public:
        TRunner();

        void Run(TContext::TPtr context, const TZtStringBuf &function);

        void Run(TContext::TPtr context, const TZtStringBuf &function, const NJson::TJsonValue &value) {
            Run(std::move(context), function, {std::cref(value)});
        }

        void Run(TContext::TPtr context, const TZtStringBuf &function, const NJson::TJsonValue &value1,
                 const NJson::TJsonValue &value2) {
            Run(std::move(context), function, {std::cref(value1), std::cref(value2)});
        }

        void Run(TContext::TPtr context, const TZtStringBuf &function, const TVector<NJson::TJsonValue> &values);

        bool FunctionExists(const TZtStringBuf &function);

        void Load(const TFsPath &entry);

        void Load(IInputStream &stream, const TZtStringBuf &tag);

        void Load(IInputStream &&stream, const TZtStringBuf &tag);

        [[nodiscard]] TRunner Clone() const;

    private:
        TLuaStateHolder LuaStateHolder;
        TVector<std::pair<TString, TBuffer>> AllScripts;
    };
}
