#include "sender.h"
#include "gc.h"
#include "personal_filter.h"
#include "abook.h"

namespace NLua {
    int TSender::Uid(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.Uid);
        return 1;
    }

    int TSender::Suid(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.Suid);
        return 1;
    }

    int TSender::Login(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.Login);
        return 1;
    }

    int TSender::Domain(TLuaStateHolder &state) const {
        state.require(1);
        state.push_string(Base.Domain);
        return 1;
    }

    int TSender::ValidInReplyTo(TLuaStateHolder &state) const {
        state.require(1);
        state.push_bool(Base.ValidInReplyTo);
        return 1;
    }

    int TSender::ValidReferences(TLuaStateHolder &state) const {
        state.require(1);
        state.push_bool(Base.ValidReferences);
        return 1;
    }

    int TSender::PersonalFilter(TLuaStateHolder &state) const {
        state.require(1);
        if (Base.PersonalFilter) {
            state.push_userdata(TPersonalFilter(*Base.PersonalFilter));
        } else {
            state.push_nil();
        }
        return 1;
    }

    int TSender::AbookInfo(TLuaStateHolder &state) const {
        state.require(1);
        state.push_userdata(TAbookInfo(Base.AbookInfo));
        return 1;
    }

    TSender::TSender(const NHtmlSanMisc::TSender &base) noexcept: Base(base) {}

    const luaL_Reg TSender::LUA_FUNCTIONS[] = {
            {"uid",               NLua::MethodConstHandler<TSender, &TSender::Uid>},
            {"suid",              NLua::MethodConstHandler<TSender, &TSender::Suid>},
            {"login",             NLua::MethodConstHandler<TSender, &TSender::Login>},
            {"domain",            NLua::MethodConstHandler<TSender, &TSender::Domain>},
            {"valid_in_reply_to", NLua::MethodConstHandler<TSender, &TSender::ValidInReplyTo>},
            {"valid_references",  NLua::MethodConstHandler<TSender, &TSender::ValidReferences>},
            {"pf",                NLua::MethodConstHandler<TSender, &TSender::PersonalFilter>},
            {"abook",             NLua::MethodConstHandler<TSender, &TSender::AbookInfo>},
            {GC,                  NLua::Destructor<TSender>},
            {nullptr,             nullptr}};

    const char TSender::LUA_METATABLE_NAME[] = "sender_mt";
}
