#include <library/cpp/lua/json.h>

#include "so2_answer.h"
#include "gc.h"
#include "sender.h"

namespace NLua {
    int TAnswer::GetSenders(TLuaStateHolder &state) const {
        state.require(1);
        state.create_table();
        int index = 1;
        for (const NHtmlSanMisc::TSender &sender: Base.GetSenders()) {
            state.push_userdata(TSender(sender));
            state.rawseti(-2, index++);
        }
        return 1;
    }

    int TAnswer::GetDocs(TLuaStateHolder &state) const {
        state.require(1);
        state.create_table();
        int index = 1;
        for (const NHtmlSanMisc::TDoc &doc: Base.Docs()) {
            NLua::PushJsonValue(&state, doc.Source);
            state.rawseti(-2, index++);
        }
        return 1;
    }

    int TAnswer::GetSource(TLuaStateHolder &state) const {
        state.require(1);
        NLua::PushJsonValue(&state, Base.GetSource());
        return 1;
    }

    TAnswer::TAnswer(const NHtmlSanMisc::TAnswer &base) noexcept: Base(base) {}

    const luaL_Reg TAnswer::LUA_FUNCTIONS[] = {
            {"get_senders", NLua::MethodConstHandler<TAnswer, &TAnswer::GetSenders>},
            {"get_docs",    NLua::MethodConstHandler<TAnswer, &TAnswer::GetDocs>},
            {"get_source",  NLua::MethodConstHandler<TAnswer, &TAnswer::GetSource>},
            {GC,            NLua::Destructor<TAnswer>},
            {nullptr,       nullptr}};

    const char TAnswer::LUA_METATABLE_NAME[] = "so2_answer_mt";
}
