#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/lua/wrapper.h>
#include <mail/so/libs/lua_rules/pcre.h>
#include <mail/so/libs/lua_rules/runner.h>
#include <mail/so/libs/lua_rules/rule.h>
#include <library/cpp/json/json_reader.h>
#include <util/stream/file.h>
#include "dummy_context.h"


Y_UNIT_TEST_SUITE(LuaRules) {

    Y_UNIT_TEST(Main) {
        TLuaStateHolder LuaState;
        LuaState.BootStrap();
        NLua::BootstrapPcre(LuaState);

        TStringStream s;

        s << R"(
local re = pcre_compile("(?i)приветdf")
local matches = re:match("somПриветetesting", 1)
assert(matches == nil)
local re = pcre_compile("привет")
local matches = re:match("somПриветetesting", 1)
assert(matches == nil)
local matches = re:match("somприветetesting", 1)
assert(matches[1] == "привет")
local re2 = pcre_compile("(?i)привет")
local matches = re2:match("somПриветetesting", 1)
assert(matches[1] == "Привет")

)";

        LuaState.Load(&s, "test");
        LuaState.call(0, 0);
    }

    Y_UNIT_TEST(Runner) {
        TFileInput stream(ArcadiaSourceRoot() +
                          "/mail/so/daemons/so2/so2/test/resources/ru/yandex/mail/so2/senders-so-response2.json");
        const NHtmlSanMisc::TAnswer answer = NHtmlSanMisc::TAnswer::Parse(NJson::ReadJsonTree(&stream, true));

        NRulesDummyContext::TContext context(answer);

        {
            NLua::TRunner runner;
            runner.Load(SRC_("script.lua"));

            UNIT_ASSERT(runner.FunctionExists("rule"));
            UNIT_ASSERT(runner.FunctionExists("tonumber"));

            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule1"), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule2"), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule3"), yexception);
            UNIT_ASSERT(context.GetDlvLog().GetLogValues().empty());
            UNIT_ASSERT(context.GetMlLog().GetLogValues().empty());

            NLua::TRunner newRunner = runner.Clone();
            newRunner.Run(context.AsPtr(), "rule", "пример с криллическим текстом");

            UNIT_ASSERT(context.GetRuleProvider().Get("rule1").IsActive());
            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule2"), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule3"), yexception);
            {
                const THashMap<TString, TString> expected{{"some_meanfull_key1", "some_meanfull_value1"}};
                UNIT_ASSERT_VALUES_EQUAL(expected, context.GetDlvLog().GetLogValues());
            }
            UNIT_ASSERT(context.GetMlLog().GetLogValues().empty());

            newRunner.Run(context.AsPtr(), "rule", "example with english text");

            UNIT_ASSERT(context.GetRuleProvider().Get("rule1").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("rule2").IsActive());
            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get("rule3"), yexception);
            {
                const THashMap<TString, TString> expected{{"some_meanfull_key1", "some_meanfull_value1"}};
                UNIT_ASSERT_VALUES_EQUAL(expected, context.GetDlvLog().GetLogValues());
            }
            {
                const THashMap<TString, TString> expected{{"some_meanfull_key2", "some_meanfull_value2"}};
                UNIT_ASSERT_VALUES_EQUAL(expected, context.GetMlLog().GetLogValues());
            }

            newRunner.Run(context.AsPtr(), "rule_multi_args", "пример с текстом", "example with english text");

            UNIT_ASSERT(context.GetRuleProvider().Get("rule1").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("rule2").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("rule3").IsActive());

            UNIT_ASSERT(context.GetTypes().empty());

            newRunner.Run(context.AsPtr(), "rule_just_for_so2_context");

            UNIT_ASSERT(context.GetRuleProvider().Get("rule3").IsActive());
            {
                const TVector<TString> expected{"correspond"};
                UNIT_ASSERT_VALUES_EQUAL(expected, context.GetTypes());
            }
        }
    }
}
