local re1 = pcre_compile("(?i)Текст")
local re2 = pcre_compile("(?i)Text")
function rule(context, value)
    print(context)
    print(value)
    if re1:match(value) then
        context:dlv_log("some_meanfull_key1", "some_meanfull_value1")
        context:activate_rule("rule1")
        assert(context:is_rule_active("rule1"))
    end
    if re2:match(value) then
        context:dlv_log("some_meanfull_key1", "some_meanfull_value3")
        context:ml_log("some_meanfull_key2", "some_meanfull_value2")
        context:activate_rule("rule2")
        assert(context:is_rule_active("rule2"))
    end
end

function rule_multi_args(context, value1, value2)
    print(context)
    print(value1)
    print(value2)
    local rule = context:get_rule("rule3")
    assert(rule:is_active() == false)
    assert(rule:get_score() == 0.)
    rule:set_score(42)
    assert(rule:get_score() == 42.)
    rule:add_score(43.)
    assert(rule:get_score() == 85.)
    rule:set_score("44")
    assert(rule:get_score() == 44.)
    if re1:match(value1) and re2:match(value2)  then
        rule:activate()
        assert(rule:is_active())
    end
end

function tablelength(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end


function rule_just_for_so2_context(context)
    local so2Context = context:get_so2_context()
    assert(so2Context)

    local senders = so2Context:get_senders()
    assert(senders)

    assert(tablelength(senders) == 4, tablelength(senders))

    local sender = senders[1]

    assert(sender:uid() == "5598601")
    assert(sender:suid() == "12054080")
    assert(sender:login() == "arttech051@gmail.com")
    assert(sender:domain() == "gmail.com")
    assert(sender:valid_in_reply_to() == true)
    assert(sender:valid_references() == false)

    local abook = sender:abook()

    assert(abook:sent_count() == 0)
    assert(abook:received_count() == 0)
    assert(abook:received_read_count() == 0)
    assert(abook:domain_received_count() == 0)
    assert(abook:domain_received_read_count() == 0)
    assert(abook:times_contacted() == 0)
    assert(abook:source_type() == "")

    local pf = sender:pf()
    assert(pf == nil)

    local sender = senders[2]

    assert(sender:uid() == "67061658")
    assert(sender:suid() == "183442461")
    assert(sender:login() == "arttech051@gmail.com")
    assert(sender:domain() == "gmail.com")
    assert(sender:valid_in_reply_to() == true)
    assert(sender:valid_references() == true)

    local abook = sender:abook()

    assert(abook:sent_count() == 3)
    assert(abook:received_count() == 2)
    assert(abook:received_read_count() == 2)
    assert(abook:domain_received_count() == 23)
    assert(abook:domain_received_read_count() == 10)
    assert(abook:times_contacted() == 3)
    assert(abook:source_type() == "ya_sent")

    local pf = sender:pf()
    assert(pf)

    assert(pf:last_type() == "ham")
    assert(pf:hams() == 1)
    assert(pf:spams() == 0)

    context:add_type("correspond")

    assert(math.abs(so2Context:get_source().text_part_wmd_distance - 0.9037391543388367) < 1e-3, so2Context:get_source().text_part_wmd_distance);
end
