#include "mhash.h"

mhash::mhash() noexcept = default;

mhash::mhash(const TBlob &newBlob) : mhash() {
    init(newBlob);
}

bool mhash::find(ui64 val) const {
    if (!bInit)
        return false;

    if (!rmem)
        return true;

    size_t idx = val % 256000;

    if (rmem[idx].off == (size_t) - 2)
        return false;
    else
        do {
            if (rmem[idx].val == val)
                return true;

            if (rmem[idx].off == (size_t) - 1)
                return false;

            idx = rmem[idx].off;
        } while (true);
}

void mhash::init(const TBlob &newBlob) {
    blob = newBlob;
    rmem = reinterpret_cast<const mnode *>(reinterpret_cast<const char *>(blob.Data()) + sizeof(size_t));
    bInit = true;
}

#define FNV0_64_INIT ((ui64)0)
#define FNV1_64_INIT ((ui64)0xcbf29ce484222325ULL)

/*
 * 32 bit magic FNV-0 and FNV-1 prime
 */
#define FNV_64_PRIME ((ui64)0x100000001b3ULL)


ui64 hash_funck(const void* buf, size_t len) {
    ui64 hval = FNV1_64_INIT;
    unsigned char* bp = (unsigned char*)buf; /* start of buffer */
    unsigned char* be = bp + len;            /* beyond end of buffer */

    /*
     * FNV-1 hash each octet of the buffer
     */
    while (bp < be) {
        /* multiply by the 64 bit FNV magic prime mod 2^64 */
        hval *= FNV_64_PRIME;

        /* xor the bottom with the current octet */
        hval ^= (ui64)(koi8_tolower(*bp++));
    }

    return hval;
}

int koi8_tolower(int c1) {
    unsigned c = c1 & 0xff;
    if (c >= 'A' && c <= 'Z' || c >= 0340 && c <= 0377)
        c ^= 040;
    else if (c == 0263)
        c = 0243;
    return c;
}