#include <library/cpp/testing/unittest/registar.h>
#include "pool.h"

Y_UNIT_TEST_SUITE(Pool) {
    using TTestPool = TPool<size_t>;
    struct TTestTraits : public TTestPool::TPoolItemTraits {
        THolder<size_t> create() const override {
            return MakeHolder<size_t>(size_t(0));
        }
    };

    Y_UNIT_TEST(Main) {
        TTestTraits traits;
        TTestPool pool(TPoolParams(5, TDuration::Hours(1)));

        auto holder = pool.get(traits);
        UNIT_ASSERT_EQUAL(*holder, 0);
        *holder = 1;

        holder = pool.get(traits);
        UNIT_ASSERT_EQUAL(*holder, 0);

        holder = pool.get(traits);
        UNIT_ASSERT_EQUAL(*holder, 1);
    }
}
