#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/stream/output.h>
#include <util/ysaveload.h>

#define StringClassTemplate(name)   \
    class name : public TString {   \
    public: \
        using TString::TString; \
        const TString &AsString() const noexcept {  \
            return static_cast<const TString &>(*this); \
        }                           \
        TString &AsMutableString() noexcept {  \
            return static_cast<TString &>(*this); \
        }                           \
        inline void Save(IOutputStream* s) const { \
            ::SaveMany(s, AsString());            \
        }                                          \
                                                   \
        inline void Load(IInputStream* s) {        \
            ::LoadMany(s, AsMutableString());            \
        }   \
    };  \
    Y_DECLARE_OUT_SPEC(inline, name, s, v) {  \
        s.Write(v.data(), v.size());    \
    }                               \
    template <> \
    struct THash<name> : THash<TString> {};

StringClassTemplate(TUid)

StringClassTemplate(TSuid)

StringClassTemplate(TLogin)

StringClassTemplate(TDomain)

#undef StringClassTemplate
