#pragma once

#ifndef _BTRIE_H_INCLUDED
#define _BTRIE_H_INCLUDED

#include "config.h"

#ifndef NO_STDINT_H
#include <stdint.h>
typedef uint8_t btrie_oct_t;
#else
typedef unsigned char btrie_oct_t;
#endif

/* maximum length of bit string btrie_walk() can handle
 *
 * note: this limit is necessitated by the use of fixed length buffers
 * in btrie_walk() --- btrie_add_prefix() and btrie_lookup() impose no
 * limit on the length of bitstrings
 */
#define BTRIE_MAX_PREFIX 128

struct btrie;
struct mempool;

struct btrie* btrie_init(struct mempool* mp);

enum btrie_result {
    BTRIE_OKAY = 0,
    BTRIE_ALLOC_FAILED = -1,
    BTRIE_DUPLICATE_PREFIX = 1
};

enum btrie_result btrie_add_prefix(struct btrie* btrie,
                                   const btrie_oct_t* prefix, unsigned len,
                                   const void* data);

const void* btrie_lookup(const struct btrie* btrie,
                         const btrie_oct_t* pfx, unsigned len);

const char* btrie_stats(const struct btrie* btrie);

#ifndef NO_MASTER_DUMP
typedef void btrie_walk_cb_t(const btrie_oct_t* prefix, unsigned len,
                             const void* data, int post, void* user_data);

void btrie_walk(const struct btrie* btrie,
                btrie_walk_cb_t* callback, void* user_data);
#endif /* not NO_MASTER_DUMP */

#endif /* _BTRIE_H_INCLUDED */
