#include "timeoutread.h"

#ifdef _MSC_VER
#include <io.h>
#include <winsock2.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <util/network/init.h>
#include <errno.h>

#endif

int timeoutread(int timeout, SOCKET fd, char* buf, int len)
{
    fd_set rfds;
    struct timeval tv;

    tv.tv_sec = timeout;
    tv.tv_usec = 0;

    FD_ZERO(&rfds);
    FD_SET(fd, &rfds);

    if (select(fd + 1, &rfds, (fd_set*)0, (fd_set*)0, &tv) == SOCKET_ERROR)
        return -1;

    if (FD_ISSET(fd, &rfds))
        //#ifdef _MSC_VER
        return recv(fd, buf, len, 0);
    //#else
    //        return read (fd, buf, len);
    //#endif
    errno = ETIMEDOUT;
    return -1;
}
