#include "timeoutwrite.h"

#ifdef _MSC_VER
#include <io.h>
#include <winsock2.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#endif

int timeoutwrite(int timeout, SOCKET fd, const char* buf, int len)
{
    if (fd < 0)
        return -1;
    fd_set wfds;
    struct timeval tv;

    tv.tv_sec = timeout;
    tv.tv_usec = 0;

    FD_ZERO(&wfds);
    FD_SET(fd, &wfds);

    if (select(fd + 1, (fd_set*)0, &wfds, (fd_set*)0, &tv) == -1)
        return -1;

    if (FD_ISSET(fd, &wfds))
#ifdef _MSC_VER
        return send(fd, buf, len, 0);
#else
        return write(fd, buf, len);
#endif

    errno = ETIMEDOUT;
    return -1;
}
