#include "so_log.h"

#include <library/cpp/logger/all.h>
#include <library/cpp/threading/thread_local/thread_local.h>

#include <util/datetime/base.h>

#include <util/system/thread.h>
#include <util/string/printf.h>
#include <library/cpp/logger/filter.h>
#include <util/string/builder.h>


TString TimePidFormatter(ELogPriority priority, TStringBuf data) {
    return TStringBuilder{} << Now().ToStringLocal()
                            << '[' << TThread::CurrentThreadId() << ']' << ' '
                            << priority << ' '
                            << data << '\n';
}

TString TimePidQidFormatter(ELogPriority priority, TStringBuf data, TStringBuf qid) {
    return TStringBuilder{} << Now().ToStringLocal()
                            << '<' << qid << '>'
                            << '[' << TThread::CurrentThreadId() << ']' << ' '
                            << priority << ' '
                            << data << '\n';
}

static TLog CreateLog() {
    TLog logger(CreateFilteredOwningThreadedLogBackend("cout", TLOG_RESOURCES));
    logger.SetFormatter(TimePidFormatter);
    return logger;
}

TLog &SysLogger() {
    static TLog logger = CreateLog();
    return logger;
}

void Openlog(const TFsPath &fakeSyslog, ELogPriority priority) {
    auto back = CreateFilteredOwningThreadedLogBackend(fakeSyslog ? fakeSyslog : "cout", priority);

    SysLogger().ResetBackend(std::move(back));
}

void ReopenLog() {
    SysLogger().ReopenLog();
}

TLogElement Syslog(ELogPriority priority) {
    return SysLogger() << priority;
}
