#pragma once

#include <util/folder/path.h>
#include <library/cpp/logger/priority.h>
#include <library/cpp/logger/element.h>

void Openlog(const TFsPath &fakeSyslog, ELogPriority priority);

void ReopenLog();

TString TimePidFormatter(ELogPriority priority, TStringBuf data);
TString TimePidQidFormatter(ELogPriority priority, TStringBuf data, TStringBuf qid);

TLog &SysLogger();

TLogElement Syslog(ELogPriority priority);

inline TString CurrentExceptionMessageWithBt() {
    return CurrentExceptionMessage() + " bt: " + TBackTrace::FromCurrentException().PrintToString();
}