#include "config.h"

using namespace NConfig;

namespace NTalkativeConfig {
    const TConfig& Get(const TConfig& config, const TStringBuf& name) {
        if (!config.IsA<TDict>())
            ythrow TWithBackTrace<yexception>() << "config: " << config << " must be a dict for search field: " << name;

        if (auto it = MapFindPtr(config.Get<TDict>(), name))
            return *it;
        ythrow TWithBackTrace<yexception>() << "cannot find " << name << " in " << config;
    }

    const NConfig::TConfig* Find(const NConfig::TConfig& config, const TStringBuf& name) {
        if (!config.IsA<TDict>())
            return nullptr;

        return MapFindPtr(config.Get<TDict>(), name);
    }
} // namespace NTalkativeConfig
