#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/string.h>
#include <library/cpp/config/config.h>
#include "config.h"

Y_UNIT_TEST_SUITE(NTalkativeConfig) {
    Y_UNIT_TEST(Main) {

        TStringStream src;
        {
            src <<
                "{"
                    "\"resolution\": \"100s\","
                    "\"offset\": \"2000-01-01\","
                    "\"int\": 789,"
                    "\"ui64\": 18446744073709551615"
                "}";
        }
        const auto & config = NConfig::TConfig::FromJson(src);

        UNIT_ASSERT_NO_EXCEPTION(NTalkativeConfig::Get<NConfig::TDict>(config));

        UNIT_ASSERT_EXCEPTION(NTalkativeConfig::Get<NConfig::TArray>(config), yexception);

        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get<TString>(config, "resolution"), "100s");
        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<TString>(config, "resolution"), "100s");

        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get(config, "resolution").Get<TString>(), "100s");
        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get(config, "resolution").As<TString>(), "100s");

        UNIT_ASSERT_EXCEPTION(NTalkativeConfig::Get(config, "some_stuff"), yexception);

        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get<i64>(config, "int"), 789);
        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<i64>(config, "int"), 789);

        UNIT_ASSERT_EXCEPTION(NTalkativeConfig::Get<ui64>(config, "int"), yexception);

        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get<i64>(config, "int"), 789);
        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<i64>(config, "int"), 789);

        UNIT_ASSERT_EQUAL(NTalkativeConfig::Get<ui64>(config, "ui64"), ui64(18446744073709551615ull));
        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<ui64>(config, "ui64"), ui64(18446744073709551615ull));

        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<TInstant>(config, "offset"), TInstant::ParseIso8601("2000-01-01"));

        UNIT_ASSERT_EQUAL(NTalkativeConfig::As<TDuration>(config, "resolution"), TDuration::Seconds(100));

//        TInstant GetInstant(const NConfig::TConfig &config, const TString &name);
//
//        TDuration GetDuration(const NConfig::TConfig &config, const TString &name);
    }
}

