#pragma once

#include <util/generic/vector.h>
#include <util/generic/strbuf.h>
#include <library/cpp/containers/comptrie/comptrie_builder.h>

namespace NTld {
    TVector<TString> ReadTlds(IInputStream *stream);

    class TDetector{
        using TTrie = TCompactTrie<char, bool>;
        using TTrieBuilder = TCompactTrieBuilder<char, bool>;
    public:
        TDetector();
        explicit TDetector(const TVector<TString>& tlds);

        size_t FindLongestTldSuffixSize(TString host) const;
        bool IsTld(TString host) const;

    private:
        TTrie Trie;
    };
}