#include <library/cpp/testing/unittest/registar.h>

#include <util/string/join.h>

#include <mail/so/libs/tld/is_tld.h>

using namespace NTld;

Y_UNIT_TEST_SUITE(IsTld) {
    Y_UNIT_TEST(Default) {
        const NTld::TDetector detector;

        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("aero"), NPOS);
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("civilaviation.aero"), strlen("aero"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("ya.com.civilaviation.aero"), strlen("aero"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("ya.com.civilaviation.aero.ru"), strlen("ru"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("asd.civilaviation.aeroaasdru"), NPOS);
    }
    Y_UNIT_TEST(Read) {


        const TString data = R"(
//ru
    .ya
en

com
yandex.com
)";
        TStringInput stream(data);
        const auto tlds = NTld::ReadTlds(&stream);

        {
            const TVector<TString> expected{"ya", "en", "com", "yandex.com"};
            UNIT_ASSERT_EQUAL_C(tlds, expected, JoinSeq(",", tlds));
        }

        const NTld::TDetector detector(tlds);

        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("civilaviation.ya"), strlen("ya"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("en"), NPOS);
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("en.yandex.com"), strlen("yandex.com"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize("en.ru.com"), strlen("com"));
        UNIT_ASSERT_EQUAL(detector.FindLongestTldSuffixSize(""), NPOS);

        UNIT_ASSERT(!detector.IsTld("civilaviation.ya"));
        UNIT_ASSERT(detector.IsTld("ya"));
        UNIT_ASSERT(detector.IsTld("en"));
        UNIT_ASSERT(!detector.IsTld("ya.en"));
        UNIT_ASSERT(detector.IsTld("yandex.com"));
        UNIT_ASSERT(detector.IsTld("com"));
    }
}

