#include <mail/so/libs/unperson/unperson.h>

#include <util/memory/blob.h>
#include <util/stream/input.h>
#include <util/stream/output.h>

int main(int argc, char** argv) {
    if (argc < 2) {
        Cerr << "Usage: " << argv[0] << " <config-file>" << Endl;
        return 1;
    }
    TBlob config{TBlob::FromFile(argv[1])};
    void* instance;
    int res = JniWrapperCreateUnperson(
        TString{config.AsCharPtr(), config.Length()}.c_str(),
        &instance);
    if (res != 0) {
        Cerr << "Failed to construct unperson: " << (const char*) instance << Endl;
        free(instance);
        return 2;
    }
    TUtf16String line;
    while (true) {
        if (!Cin.ReadLine(line)) {
            break;
        }
        wchar16* out;
        size_t outLen;
        res = JniWrapperUnpersonText(
            instance,
            line.c_str(),
            line.Size(),
            nullptr,
            0,
            nullptr,
            0,
            &out,
            &outLen);
        if (res) {
            Cerr << "Failed to process line <" << line << ">: " << TWtringBuf{out, outLen} << Endl;
            free(out);
            break;
        }
        Cout << TWtringBuf{out, outLen} << Endl;
        free(out);
    }
    JniWrapperDestroyUnperson(instance);
}

