#pragma once

#include "erasure_type.h"
#include "token_type.h"

#include <util/generic/hash_set.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NTextDeobfuscate {
    class TTextDeobfuscator;
}

namespace NUnperson {
    class TLemmerCache;
    class TDeobfuscatorCache;

    TUtf32String EraseMarks(const TUtf32String& str, bool fixShortI);

    class TUnperson {
    public:
        TUnperson(bool erasePersonalInfo = true);

        TUnperson(
            EErasureType erasureType,
            const NTextDeobfuscate::TTextDeobfuscator* deobfuscator = nullptr,
            const TUtf16String& fusedTokensSeparator = u"",
            size_t maxTokens = Max(),
            const THashSet<TUtf16String>& ignoreList = THashSet<TUtf16String>(),
            bool unpersonUri = true,
            bool eraseSingleLetterWords = false,
            bool eraseStopWords = false,
            bool fixShortI = false,
            bool oneSentencePerLine = false,
            bool bestEffortSentenceTokenizer = false);

        virtual ~TUnperson();

        TUtf16String UnpersonText(
            TWtringBuf str,
            TLemmerCache& lemmerCache,
            TDeobfuscatorCache* deobfuscatorCache = nullptr) const;

        TUtf16String UnpersonText(
            TWtringBuf str,
            const THashSet<ETokenType>& bypassTokens,
            TLemmerCache& lemmerCache,
            TDeobfuscatorCache* deobfuscatorCache) const;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}

extern "C" {
    int JniWrapperCreateUnperson(const char* config, void** out) noexcept;

    void JniWrapperDestroyUnperson(void* instance) noexcept;

    int JniWrapperUnpersonText(
        void* instance,
        const wchar16* text,
        size_t textLen,
        const wchar16* metainfo,
        size_t metainfoLen,
        const void* data,
        size_t size,
        wchar16** out,
        size_t* outLen) noexcept;
}

