#pragma once

#include <util/generic/strbuf.h>

namespace NUnperson {
    class TToken;

    class TUnpersonListener {
    public:
        // all methods returns true if execution should proceed
        // and false if execution should be aborted

        // Will output text as is
        [[nodiscard]] virtual bool OnClearText(TWtringBuf text) = 0;

        // Will obfuscate token text
        [[nodiscard]] virtual bool OnToken(const TToken& token) = 0;

        // Will go deeper by tokenizers
        [[nodiscard]] virtual bool OnText(TWtringBuf text) = 0;
    };
}

