#include <library/cpp/testing/unittest/registar.h>
#include <util/string/join.h>
#include <numeric>
#include <util/digest/fnv.h>
#include <util/random/easy.h>
#include <alloca.h>
#include <util/generic/array_ref.h>
#include <util/string/split.h>
#include <util/stream/file.h>

#include "wmd.h"

using namespace NWmd;

Y_UNIT_TEST_SUITE(Wmd) {

//    Y_UNIT_TEST(Main) {
//        const size_t totalAttempts = 100;
//
//        for (size_t size : {3, 10, 32, 100, 317}) {
//
//            TDuration time;
//
//            TMatrix distances{TVector<float>(size * size), size, size};
//            for (size_t attempt = 0; attempt < totalAttempts; attempt++) {
//
//                std::generate_n(distances.Data.data(), size * size, Random);
//
//                const auto start = Now();
////                const auto score = WMD(weights);
//                time += Now() - start;
//
//                SingleWeightACT(distances);
//
////                UNIT_ASSERT_LE_C(estimation, score + 1e-3, estimation << " vs " << score);
//            }
//            Cout << size * size << ':' << time / double(totalAttempts) << Endl;
//        }
//    }

        Y_UNIT_TEST(Valid) {


            float data[] = {
                    2, 2, 2, 2, 1,
                    2, 2, 0, 1, 2,
                    2, 2, 1, 2, 2,
                    2, 1, 2, 2, 2};

            auto cost = GreedWmd(data, 5, 4, 2.f);
            UNIT_ASSERT_DOUBLES_EQUAL(1.2, cost, 1e-3);
            cost = RelaxedWmd(data, 5, 4, 2.f);
            UNIT_ASSERT_DOUBLES_EQUAL(1, cost, 1e-3);
        }

        Y_UNIT_TEST(SingleRow) {
            {
                float data[] = {1, 2, 3};
                auto cost = GreedWmd(data, 1, 3, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(2.333, cost, 1e-3);
                cost = RelaxedWmd(data, 1, 3, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(2.333, cost, 1e-3);
            }
            {
                float data[] = {1, 2, 3};
                auto cost = GreedWmd(data, 3, 1, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(2.333, cost, 1e-3);
                cost = RelaxedWmd(data, 3, 1, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(2.333, cost, 1e-3);
            }
//        {
//            const auto cost = WMD(distances);
//            UNIT_ASSERT_DOUBLES_EQUAL(1, cost, 1e-3);
//        }
        }

        Y_UNIT_TEST(Zero) {
            {
                auto cost = GreedWmd(nullptr, 0, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(1, cost, 1e-3);
                cost = RelaxedWmd(nullptr, 0, 3);
                UNIT_ASSERT_DOUBLES_EQUAL(1, cost, 1e-3);

                cost = GreedWmd(nullptr, 0, 0);
                UNIT_ASSERT_DOUBLES_EQUAL(-1, cost, 1e-3);
                cost = RelaxedWmd(nullptr, 0, 0);
                UNIT_ASSERT_DOUBLES_EQUAL(-1, cost, 1e-3);
            }
//        {
//            const auto cost = WMD(distances);
//            UNIT_ASSERT_DOUBLES_EQUAL(-1, cost, 1e-3);
//        }
        }
}
