#pragma once

#include <util/system/defaults.h>
#include <util/generic/vector.h>
#include <util/generic/noncopyable.h>

namespace NWmd {

    struct TMatrix : TMoveOnly {
        TMatrix() = default;

        TMatrix(TMatrix &&m) noexcept;

        TMatrix &operator=(TMatrix &&m) noexcept;

        TMatrix(size_t cols, size_t rows, float defaultVal);

        TMatrix(size_t cols, size_t rows);

        float &operator()(size_t row, size_t col);

        float operator()(size_t row, size_t col) const;

        float *Data{};
        size_t Cols{}, Rows{};
    private:
        void Align();

        TVector<float> Storage;
    };

    /// https://arxiv.org/abs/1812.02091
    float RelaxedWmd(float *data, size_t cols, size_t rows, float maxDistance = 1.f);

    float RelaxedWmd(TMatrix &distances, float maxDistance = 1.f);

    float RelaxedWmd(TMatrix &&distances, float maxDistances = 1.f);

    float GreedWmd(const float *data, size_t cols, size_t rows, float maxDistance = 1.f);

    float GreedWmd(TMatrix &distances, float maxDistance = 1.f);

    float GreedWmd(TMatrix &&distances, float maxDistances = 1.f);
} // namespace NWmd
