#include <library/cpp/testing/unittest/registar.h>
#include <mail/so/libs/fast_text/fasttext.h>
#include <util/string/split.h>
#include <util/system/hp_timer.h>
#include <util/generic/vector.h>
#include <library/cpp/dot_product/dot_product.h>
#include <mail/so/libs/wmd/wmd.h>
#include <mail/so/libs/wmd_fast_text/wmd.h>
#include <sstream>
#include <cstdlib>


Y_UNIT_TEST_SUITE(FastText) {
    Y_UNIT_TEST(Main) {
        fasttext::FastText model;
        model.loadModel("pures-e15.model.bin");

        const fasttext::TDoc doc1("посмотреть письмо браузере %Uri% %Uri% %Uri% новогодняя распродажа скидки %Uri% конца новогодней распродажи осталась неделя ждет больше десяти тысяч классных предложений выгодой упустите возможность перейти распродаже %Uri% дополнительная выгода самовывозе выберите", model);
        const fasttext::TDoc doc2("посмотреть письмо браузере конца новогодней распродажи осталась неделя ждет больше десяти тысяч классных предложений выгодой упустите возможность перейти распродаже перейти категорию электрических зубных щетки oral pro %ShortNumber% vitality frozen скидка %ShortNumber%", model);
        const fasttext::TDoc doc3("новые вакансии резюме специалист логистике нашли несколько вакансий которые могут подойти помощник документы %Number% %Number% руб %LastName% %Date% начинающий специалист %Number% %Number% руб %LastName% %FirstName% %SecondName% %Date% специалист терминального отдела транспортно логистическую компанию", model);
        constexpr size_t iterations = 10000;

        {
            THPTimer timer;
            double sum1 = 0;
            double sum2 = 0;
            for (size_t i = 0; i < iterations; ++i) {
                sum1 += NWmd::RelaxedWmd(fasttext::MakeDistances(doc1, doc2));
                sum2 += NWmd::RelaxedWmd(fasttext::MakeDistances(doc2, doc3));
            }
            Cerr << sum1 / iterations << ' ' << sum2 / iterations << Endl;
            UNIT_ASSERT_LT(sum1, sum2);
            Cerr << "Relaxed time taken: " << timer.Passed() << Endl;
        }
        {
            THPTimer timer;
            double sum1 = 0;
            double sum2 = 0;
            for (size_t i = 0; i < iterations; ++i) {
                sum1 += NWmd::GreedWmd(fasttext::MakeDistances(doc1, doc2));
                sum2 += NWmd::GreedWmd(fasttext::MakeDistances(doc2, doc3));
            }
            Cerr << sum1 / iterations << ' ' << sum2 / iterations << Endl;
            UNIT_ASSERT_LT(sum1, sum2);
            Cerr << "Greed time taken: " << timer.Passed() << Endl;
        }
    }

    Y_UNIT_TEST(TestFalseRelaxedProximity) {
        fasttext::FastText model;
        model.loadModel("full.bin");
        const fasttext::TDoc spam("здравствуйте\n%FirstName% %LastName% %Number%\n%Uri% уважением\n%LastName% %FirstName% %SecondName%", model);
        const fasttext::TDoc ham("уважением %FirstName% %SecondName% %LastName%\n8 %Number% %Number%\n%Number%\n%Uri%", model);
        double relaxedDistance = NWmd::RelaxedWmd(fasttext::MakeDistances(spam, ham));
        double greedDistance = NWmd::GreedWmd(fasttext::MakeDistances(spam, ham));
        UNIT_ASSERT_LT(relaxedDistance, greedDistance);
        UNIT_ASSERT_GT(greedDistance, 0.1);
        Cerr << relaxedDistance << ' ' << greedDistance << Endl;
    }

    Y_UNIT_TEST(TestDistanceEquality) {
        fasttext::FastText model;
        model.loadModel("full.bin");
        const fasttext::TDoc spam("здравствуйте\n%FirstName% %LastName% %Number%\n%Date% уважением\n%LastName% %FirstName% %SecondName%", model);
        const fasttext::TDoc ham("уважением %FirstName% %SecondName% %LastName%\nздравствуйте %FirstName% %LastName% %Number%\n%Time%", model);
        double relaxedDistance = NWmd::RelaxedWmd(fasttext::MakeDistances(spam, ham));
        double greedDistance = NWmd::GreedWmd(fasttext::MakeDistances(spam, ham));
        UNIT_ASSERT_DOUBLES_EQUAL(relaxedDistance, greedDistance, 0.0001);
        UNIT_ASSERT_GT(relaxedDistance, 0.01);
        Cerr << relaxedDistance << ' ' << greedDistance << Endl;
    }
}
