-------------------------------------------------------------------------------
-- encoding: utf-8
-- kate: space-indent on; indent-width 2; replace-tabs on;
--
-------------------------------------------------------------------------------
-- Таблицы статистики жалоб

---- Таблица статистики жалоб по пользователям
--DROP TABLE IF EXISTS abuses CASCADE;
CREATE TABLE IF NOT EXISTS abuses (
  id BIGSERIAL NOT NULL,
  source VARCHAR(20) DEFAULT NULL,
  stid VARCHAR(80) DEFAULT NULL,
  uid BIGINT NOT NULL DEFAULT 0,
  suid BIGINT NOT NULL DEFAULT 0,
  move SMALLINT NOT NULL DEFAULT -1,
  foo SMALLINT NOT NULL DEFAULT -1,
  cnt INTEGER NOT NULL DEFAULT 0,
  cmpldata INTEGER NOT NULL DEFAULT 0,
  data INTEGER NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS abuses_index_source;
CREATE INDEX IF NOT EXISTS abuses_index_source ON abuses (source);
--DROP INDEX IF EXISTS abuses_index_stid;
CREATE INDEX IF NOT EXISTS abuses_index_stid ON abuses (stid);
--DROP INDEX IF EXISTS abuses_index_uid;
CREATE INDEX IF NOT EXISTS abuses_index_uid ON abuses (uid);
--DROP INDEX IF EXISTS abuses_index_suid;
CREATE INDEX IF NOT EXISTS abuses_index_suid ON abuses (suid);
--DROP INDEX IF EXISTS abuses_index_data;
CREATE INDEX IF NOT EXISTS abuses_index_data ON abuses (data);
--DROP INDEX IF EXISTS abuses_index_cmpldata;
CREATE INDEX IF NOT EXISTS abuses_index_cmpldata ON abuses (cmpldata);
--DROP INDEX IF EXISTS abuses_index_check_double;
CREATE UNIQUE INDEX IF NOT EXISTS abuses_index_check_double ON abuses (stid, uid, foo);

---- Таблица посуточной статистики жалоб
--DROP TABLE IF EXISTS abuses_stat;
CREATE TABLE IF NOT EXISTS abuses_stat (
  id CHAR(10),
  foo INTEGER NOT NULL DEFAULT 0,
  antifoo INTEGER NOT NULL DEFAULT 0,
  foo_uniq INTEGER NOT NULL DEFAULT 0,
  antifoo_uniq INTEGER NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
);

---- Таблица статистики жалоб и репортов, приходящих на обработку в кластер so_complaint
--DROP TABLE IF EXISTS compl_stat;
CREATE TABLE IF NOT EXISTS compl_stat (
  id BIGSERIAL,
  "date" CHAR(10),
  source VARCHAR(20) DEFAULT NULL,
  footype VARCHAR(80) DEFAULT NULL,
  "host" VARCHAR(64) DEFAULT NULL,
  total INTEGER NOT NULL DEFAULT 0,
  empty_ip INTEGER NOT NULL DEFAULT 0,
  with_mail INTEGER NOT NULL DEFAULT 0,
  seen VARCHAR(8) DEFAULT NULL,
  min_time INTEGER NOT NULL DEFAULT 0,
  max_time BIGINT NOT NULL DEFAULT 0,
  accum_time BIGINT NOT NULL DEFAULT 0,
  http_200 INTEGER NOT NULL DEFAULT 0,
  http_4xx INTEGER NOT NULL DEFAULT 0,
  http_499 INTEGER NOT NULL DEFAULT 0,
  http_5xx INTEGER NOT NULL DEFAULT 0,
  http_other INTEGER NOT NULL DEFAULT 0,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS index_date;
CREATE INDEX IF NOT EXISTS index_date ON compl_stat ("date");
--DROP INDEX IF EXISTS index_source;
CREATE INDEX IF NOT EXISTS index_source ON compl_stat (source);
--DROP INDEX IF EXISTS index_footype;
CREATE INDEX IF NOT EXISTS index_footype ON compl_stat (footype);
--DROP INDEX IF EXISTS index_seen;
CREATE INDEX IF NOT EXISTS index_seen ON compl_stat (seen);
--DROP INDEX IF EXISTS index_uniq;
CREATE UNIQUE INDEX IF NOT EXISTS index_uniq ON compl_stat ("date", "host", source, footype, seen);

---- Таблица для регулирования работы скриптов, запускаемых по крону, которые обслуживают БД
--DROP TABLE IF EXISTS cron_scripts;
CREATE TABLE IF NOT EXISTS cron_scripts (
  id VARCHAR(32),
  last_start_ts TIMESTAMP DEFAULT LOCALTIMESTAMP,
  last_end_ts TIMESTAMP,
  cron_expr VARCHAR(100), -- https://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/obshayaformula/fml/reactiveconveyor/triggers/cron/
  options TEXT NOT NULL DEFAULT '',
  PRIMARY KEY (id, cron_expr)
);

---- Таблица для хранения глобальных констант времени выполнения
--DROP TABLE IF EXISTS settings;
CREATE TABLE IF NOT EXISTS settings (
  key VARCHAR(128) NOT NULL,
  "value" VARCHAR(256) DEFAULT '',
  PRIMARY KEY (key)
);
-------------------------------------------------------------------------------
