#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os.path, sys, time, psycopg2
from traceback import format_exception

WORKING_DIR = "/home/klimiky/test"
PG = {
    "host":    "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
    "port":    6432,
    "db":      "complaints",
    "user":    "cmpl"
}
def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def writelog(msg, isTB = False):
    if not msg: return
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        print >>sys.stderr, time.strftime("[%Y-%m-%d %H:%M:%S]: ") + msg + tb
    except Exception, e:
        print >>sys.stderr, "Writelog error: %s" % str(e)

def getPGCredentials(cfg):
    f, CURDIR, dbname = None, WORKING_DIR, cfg['db'][:len(cfg['db']) - 2] if cfg['db'].endswith('db') else cfg['db']
    try:
        if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
                CURDIR = os.path.dirname(os.environ['HOME'])
        f = open('{0}/.pgpass.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 5 and sf[2] == cfg['db']:
                cfg['host'], cfg['port'], cfg['user'], cfg['password'] = sf[0], int(sf[1]), sf[3], sf[4].strip()
                break
        f.close()
    except Exception, e:
        writelog("getPGCredentials exception: %s" % str(e), True)

def getPGdb(cfg):
    pg = None
    if hasattr(psycopg2, '__libpq_version__'):
        pg = psycopg2.connect(dbname = cfg['db'], user = cfg['user'], password = cfg['password'], host = cfg['host'], port = cfg.get('port', 6432), sslmode = 'verify-full', sslrootcert = '{0}/.postgresql/root.crt'.format(os.environ['HOME']), target_session_attrs = 'read-write')
    else:
        if ',' in cfg['host']:
            for host in cfg['host'].split(','):
                try:
                    pg = psycopg2.connect(database = cfg['db'], user = cfg['user'], password = cfg['password'], host = host, port = cfg['port'], sslmode = 'verify-full', sslrootcert = '{0}/.postgresql/root.crt'.format(os.environ['HOME']))
                    pg_cursor = pg.cursor()
                    pg_cursor.execute("SELECT pg_is_in_recovery()")
                    res = pg_cursor.fetchone()
                    pg_cursor.close()
                    if res and not res[0]:
                        return pg
                except Exception, e:
                    writelog("getPGdb exception: %s" % str(e), True)
                    continue
        else:
            pg = psycopg2.connect(database = cfg['db'], user = cfg['user'], password = cfg['password'], host = cfg['host'], port = cfg['port'], sslmode = 'verify-full', sslrootcert = '{0}/.postgresql/root.crt'.format(os.environ['HOME']))
    return pg

print "[%s]" % time.strftime("%Y-%m-%d %H:%M:%S"), "started"

getPGCredentials(PG)
pg = getPGdb(PG)
pg_cursor = pg.cursor()
pg_cursor.execute("SELECT id FROM abuses_stat WHERE foo_uniq = 0")
for record in pg_cursor.fetchall():
    time_start = int(time.mktime(time.strptime(record[0], "%Y-%m-%d")))
    time_end = time_start + 86400
    if time_end > time.time():
        continue
    foo, antifoo = set(), set()
    pg_cursor.execute("SELECT foo, uid FROM abuses WHERE cmpldata >= %s AND cmpldata < %s", (time_start, time_end))
    for row in pg_cursor:
        footype = row[0]
        if footype == 0:
            antifoo.add(row[1])
        elif footype == 1:
            foo.add(row[1])
    pg_cursor.execute("UPDATE abuses_stat SET foo_uniq = %s, antifoo_uniq = %s WHERE id = %s", (len(foo), len(antifoo), time.strftime("%Y-%m-%d")))
    pg.commit()
    print "[%s]" % time.strftime("%Y-%m-%d %H:%M:%S"), record[0], "done"
