CREATE TABLE IF NOT EXISTS clusterizer_log (
  timestamp integer NOT NULL,
  log text NOT NULL,
  PRIMARY KEY (timestamp)
);

CREATE TABLE IF NOT EXISTS clusterizer_signal (
  timestamp integer NOT NULL,
  keyword varchar(255) NOT NULL,
  indicator integer DEFAULT 0,
  percent integer DEFAULT 0,
  docscount integer DEFAULT 0,
  PRIMARY KEY (timestamp, keyword)
);

CREATE TABLE IF NOT EXISTS geogroup (
  name varchar(100) NOT NULL,
  value text NOT NULL,
  PRIMARY KEY (name)
);

CREATE TABLE IF NOT EXISTS geostatwhite (
  geo varchar(255) NOT NULL,
  PRIMARY KEY (geo)
);

CREATE TABLE IF NOT EXISTS geozone (
  id SERIAL NOT NULL,
  name varchar(100) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT index_name UNIQUE (id, name)
);

CREATE TABLE IF NOT EXISTS graph (
  timestamp integer NOT NULL,
  total integer DEFAULT 0,
  spam integer DEFAULT 0,
  malic integer DEFAULT 0,
  ips integer DEFAULT 0,
  emails integer DEFAULT 0,
  phones integer DEFAULT 0,
  rtsimple integer DEFAULT 0,
  rtchpass integer DEFAULT 0,
  rtchpassnew integer DEFAULT 0,
  rtchpassforce integer DEFAULT 0,
  rtchpassstrong integer DEFAULT 0,
  rtadmreg integer DEFAULT 0,
  rtcompletepdd integer DEFAULT 0,
  rtlightreg integer DEFAULT 0,
  rtregone integer DEFAULT 0,
  rtadmimport integer DEFAULT 0,
  rtadmsocial integer DEFAULT 0,
  rtunknown integer DEFAULT 0,
  rtpost integer DEFAULT 0,
  svmail integer DEFAULT 0,
  svunknown integer DEFAULT 0,
  svdirectlight integer DEFAULT 0,
  svnarod integer DEFAULT 0,
  svmoney integer DEFAULT 0,
  svfriends integer DEFAULT 0,
  svmusic integer DEFAULT 0,
  svsocial integer DEFAULT 0,
  svintpdd integer DEFAULT 0,
  svcloud integer DEFAULT 0,
  svwww integer DEFAULT 0,
  svdash integer DEFAULT 0,
  badgeo integer DEFAULT 0,
  newip integer DEFAULT 0,
  spam_from_good50 integer DEFAULT 0,
  spam_from_good75 integer DEFAULT 0,
  total_turkey integer DEFAULT 0,
  spam_turkey integer DEFAULT 0,
  malic_turkey integer DEFAULT 0,
  total_galatasaray integer DEFAULT 0,
  spam_galatasaray integer DEFAULT 0,
  malic_galatasaray integer DEFAULT 0,
  whitelist integer DEFAULT 0,
  locl integer DEFAULT 0,
  PRIMARY KEY (timestamp)
);

CREATE TABLE IF NOT EXISTS ip (
  lastupdate integer DEFAULT -1,
  firstreg integer DEFAULT -1,
  lastreg integer DEFAULT -1,
  all_total integer DEFAULT 0,
  all_spam integer DEFAULT 0,
  all_malic integer DEFAULT 0,
  all_ham integer DEFAULT 0,
  all_spamlic integer DEFAULT 0,
  active integer DEFAULT 0,
  chpass integer DEFAULT 0,
  ip varchar(40) NOT NULL,
  total integer NOT NULL DEFAULT 0,
  spam integer NOT NULL DEFAULT 0,
  malic integer NOT NULL DEFAULT 0,
  ham integer NOT NULL DEFAULT 0,
  spamlic integer NOT NULL DEFAULT 0,
  yesterday_total integer NOT NULL DEFAULT 0,
  yesterday_spam integer NOT NULL DEFAULT 0,
  yesterday_malic integer NOT NULL DEFAULT 0,
  yesterday_ham integer NOT NULL DEFAULT 0,
  yesterday_spamlic integer NOT NULL DEFAULT 0,
  geo integer DEFAULT NULL,
  all_chpass integer DEFAULT 0,
  PRIMARY KEY (ip),
  CONSTRAINT index_firstreg UNIQUE (ip, firstreg),
  CONSTRAINT index_lastreg UNIQUE (ip, lastreg),
  CONSTRAINT index_all_total UNIQUE (ip, all_total),
  CONSTRAINT index_all_spam UNIQUE (ip, all_spam),
  CONSTRAINT index_all_malic UNIQUE (ip, all_malic),
  CONSTRAINT index_all_ham UNIQUE (ip, all_ham),
  CONSTRAINT index_all_spamlic UNIQUE (ip, all_spamlic),
  CONSTRAINT index_active UNIQUE (ip, active),
  CONSTRAINT index_chpass UNIQUE (ip, chpass),
  CONSTRAINT index_total UNIQUE (ip, total),
  CONSTRAINT index_spam UNIQUE (ip, spam),
  CONSTRAINT index_malic UNIQUE (ip, malic),
  CONSTRAINT index_ham UNIQUE (ip, ham),
  CONSTRAINT index_spamlic UNIQUE (ip, spamlic),
  CONSTRAINT index_yesterday_total UNIQUE (ip, yesterday_total),
  CONSTRAINT index_yesterday_spam UNIQUE (ip, yesterday_spam),
  CONSTRAINT index_yesterday_malic UNIQUE (ip, yesterday_malic),
  CONSTRAINT index_yesterday_ham UNIQUE (ip, yesterday_ham),
  CONSTRAINT index_yesterday_spamlic UNIQUE (ip, yesterday_spamlic),
  CONSTRAINT index_geo UNIQUE (ip, geo),
  CONSTRAINT index_all_chpass UNIQUE (ip, all_chpass)
);

CREATE TABLE IF NOT EXISTS kpi_monthlogins (
  timestamp integer NOT NULL,
  count integer NOT NULL,
  PRIMARY KEY (timestamp)
);

CREATE TABLE IF NOT EXISTS login_ip (
  login varchar(255) NOT NULL,
  ip varchar(40) NOT NULL,
  PRIMARY KEY (login)
);
