-------------------------------------------------------------------------------
-- encoding: utf-8
-- kate: space-indent on; indent-width 2; replace-tabs on;
--
-------------------------------------------------------------------------------
-- Таблицы, обслуживающие кластеризацию

---- Таблица кусков лога, относящихся к кластеру
DROP TABLE IF EXISTS clusterizer_log;
CREATE TABLE IF NOT EXISTS clusterizer_log (
  ts integer NOT NULL,
  log text NOT NULL,
  PRIMARY KEY (ts)
);
---- Таблица собственно кластеров/сигналов
DROP TABLE IF EXISTS clusterizer_signal;
CREATE TABLE IF NOT EXISTS clusterizer_signal (
  ts integer NOT NULL,
  keyword varchar(255) NOT NULL,
  indicator integer DEFAULT 0,
  percent integer DEFAULT 0,
  docscount integer DEFAULT 0,
  PRIMARY KEY (ts, keyword)
);
-------------------------------------------------------------------------------
-- Таблицы статистик для отрисовки графиков

---- Основная таблица счётчиков для графиков
DROP TABLE IF EXISTS graph;
CREATE TABLE IF NOT EXISTS graph (
  ts integer NOT NULL,
  total integer DEFAULT 0,
  spam integer DEFAULT 0,
  malic integer DEFAULT 0,
  ips integer DEFAULT 0,
  newips integer DEFAULT 0,
  emails integer DEFAULT 0,
  phones integer DEFAULT 0,
  badgeo integer DEFAULT 0,
  spam_from_good50 integer DEFAULT 0,
  spam_from_good75 integer DEFAULT 0,
  total_turkey integer DEFAULT 0,
  spam_turkey integer DEFAULT 0,
  malic_turkey integer DEFAULT 0,
  whitelist integer DEFAULT 0,
  locl bigint DEFAULT 0,
  PRIMARY KEY (ts)
);
---- Таблица счётчиков для графиков по типам регистраций
DROP TABLE IF EXISTS graph_regtypes;
CREATE TABLE IF NOT EXISTS graph_regtypes (
  ts integer NOT NULL,
  regtype_id integer NOT NULL,
  cnt integer NOT NULL,
  PRIMARY KEY (ts, regtype_id)
);
---- Таблица счётчиков для графиков по сервисам
DROP TABLE IF EXISTS graph_services;
CREATE TABLE IF NOT EXISTS graph_services (
  ts integer NOT NULL,
  service_id integer NOT NULL,
  cnt integer NOT NULL,
  PRIMARY KEY (ts, service_id)
);
---- Таблица счётчиков для графиков по типам смены пароля
DROP TABLE IF EXISTS graph_chpass_types;
CREATE TABLE IF NOT EXISTS graph_chpass_types (
  ts integer NOT NULL,
  chpass_type_id integer NOT NULL,
  cnt integer NOT NULL,
  PRIMARY KEY (ts, chpass_type_id)
);
-------------------------------------------------------------------------------
-- Таблицы статистик для аналитики

---- Статистика по IP
DROP TABLE IF EXISTS ips;
CREATE TABLE IF NOT EXISTS ips (
  id serial NOT NULL,
  ip inet NOT NULL,
  lastupdate integer DEFAULT -1,
  firstreg integer DEFAULT -1,
  lastreg integer DEFAULT -1,
  all_total integer DEFAULT 0,
  all_spam integer DEFAULT 0,
  all_malic integer DEFAULT 0,
  all_chpass integer DEFAULT 0,
  active integer DEFAULT 0,
  chpass integer DEFAULT 0,
  total integer NOT NULL DEFAULT 0,
  spam integer NOT NULL DEFAULT 0,
  malic integer NOT NULL DEFAULT 0,
  yesterday_total integer NOT NULL DEFAULT 0,
  yesterday_spam integer NOT NULL DEFAULT 0,
  yesterday_malic integer NOT NULL DEFAULT 0,
  geo_id integer DEFAULT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_ip;
CREATE UNIQUE INDEX IF NOT EXISTS index_ip ON ips (ip);
DROP INDEX IF EXISTS index_firstreg;
CREATE INDEX IF NOT EXISTS index_firstreg ON ips (firstreg);
DROP INDEX IF EXISTS index_lastreg;
CREATE INDEX IF NOT EXISTS index_lastreg ON ips (lastreg);
DROP INDEX IF EXISTS index_all_total;
CREATE INDEX IF NOT EXISTS index_all_total ON ips (all_total);
DROP INDEX IF EXISTS index_all_spam;
CREATE INDEX IF NOT EXISTS index_all_spam ON ips (all_spam);
DROP INDEX IF EXISTS index_all_malic;
CREATE INDEX IF NOT EXISTS index_all_malic ON ips (all_malic);
DROP INDEX IF EXISTS index_active;
CREATE INDEX IF NOT EXISTS index_active ON ips (active);
DROP INDEX IF EXISTS index_chpass;
CREATE INDEX IF NOT EXISTS index_chpass ON ips (chpass);
DROP INDEX IF EXISTS index_total;
CREATE INDEX IF NOT EXISTS index_total ON ips (total);
DROP INDEX IF EXISTS index_spam;
CREATE INDEX IF NOT EXISTS index_spam ON ips (spam);
DROP INDEX IF EXISTS index_malic;
CREATE INDEX IF NOT EXISTS index_malic ON ips (malic);
DROP INDEX IF EXISTS index_yesterday_total;
CREATE INDEX IF NOT EXISTS index_yesterday_total ON ips (yesterday_total);
DROP INDEX IF EXISTS index_yesterday_spam;
CREATE INDEX IF NOT EXISTS index_yesterday_spam ON ips (yesterday_spam);
DROP INDEX IF EXISTS index_yesterday_malic;
CREATE INDEX IF NOT EXISTS index_yesterday_malic ON ips (yesterday_malic);
DROP INDEX IF EXISTS index_ip_geo_id;
CREATE INDEX IF NOT EXISTS index_ip_geo_id ON ips (geo_id);
DROP INDEX IF EXISTS index_all_chpass;
CREATE INDEX IF NOT EXISTS index_all_chpass ON ips (all_chpass);

-- Таблица регистраций логинов
DROP TABLE IF EXISTS logins;
CREATE TABLE IF NOT EXISTS logins (
  id serial NOT NULL,
  login varchar(255) NOT NULL DEFAULT 0,
  ts_reg integer NOT NULL,
  ip_id integer NOT NULL,
  regtype_id integer DEFAULT NULL,
  karma integer DEFAULT NULL,
  name varchar(120) DEFAULT NULL,
  sirname varchar(120) DEFAULT NULL,
  as_id integer DEFAULT NULL,
  geo_id integer DEFAULT NULL,
  lang char(2) DEFAULT NULL,
  last_karma integer DEFAULT NULL,
  last_ts integer NOT NULL,
  last_ip_id integer NOT NULL,
  last_as_id integer DEFAULT NULL,
  last_geo_id integer DEFAULT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_login;
CREATE UNIQUE INDEX index_login ON logins (login);
DROP INDEX IF EXISTS index_ts_reg;
CREATE INDEX IF NOT EXISTS index_ts_reg ON logins (ts_reg);
DROP INDEX IF EXISTS index_ip_id;
CREATE INDEX IF NOT EXISTS index_ip_id ON logins (ip_id);
DROP INDEX IF EXISTS index_karma;
CREATE INDEX IF NOT EXISTS index_karma ON logins (karma);
DROP INDEX IF EXISTS index_as_id;
CREATE INDEX IF NOT EXISTS index_as_id ON logins (as_id);
DROP INDEX IF EXISTS index_geo_id;
CREATE INDEX IF NOT EXISTS index_geo_id ON logins (geo_id);
DROP INDEX IF EXISTS index_lang;
CREATE INDEX IF NOT EXISTS index_lang ON logins (lang);
DROP INDEX IF EXISTS index_last_karma;
CREATE INDEX IF NOT EXISTS index_last_karma ON logins (last_karma);
DROP INDEX IF EXISTS index_last_ts;
CREATE INDEX IF NOT EXISTS index_last_ts ON logins (last_ts);
DROP INDEX IF EXISTS index_last_ip_id;
CREATE INDEX IF NOT EXISTS index_last_ip_id ON logins (last_ip_id);
DROP INDEX IF EXISTS index_last_as_id;
CREATE INDEX IF NOT EXISTS index_last_as_id ON logins (last_as_id);
DROP INDEX IF EXISTS index_last_geo_id;
CREATE INDEX IF NOT EXISTS index_last_geo_id ON logins (last_geo_id);

-- Таблица статистики смен пароля логинами
DROP TABLE IF EXISTS chpass_stat;
CREATE TABLE IF NOT EXISTS chpass_stat (
  login_id integer NOT NULL,
  ts integer NOT NULL,
  chpass_type_id integer NOT NULL,
  ip_id integer NOT NULL,
  karma integer DEFAULT NULL,
  as_id integer DEFAULT NULL,
  geo_id integer DEFAULT NULL,
  PRIMARY KEY (login_id, ts, chpass_type_id)
);
DROP INDEX IF EXISTS index_login_id;
CREATE INDEX index_login_id ON chpass_stat (login_id);
DROP INDEX IF EXISTS index_chpass_ts;
CREATE INDEX index_chpass_ts ON chpass_stat (ts);
DROP INDEX IF EXISTS index_chpass_type_id;
CREATE INDEX index_chpass_type_id ON chpass_stat (chpass_type_id);
DROP INDEX IF EXISTS index_chpass_ip_id;
CREATE INDEX index_chpass_ip_id ON chpass_stat (ip_id);
DROP INDEX IF EXISTS index_chpass_karma;
CREATE INDEX index_chpass_karma ON chpass_stat (karma);
DROP INDEX IF EXISTS index_chpass_as_id;
CREATE INDEX index_chpass_as_id ON chpass_stat (as_id);
DROP INDEX IF EXISTS index_chpass_geo_id;
CREATE INDEX index_chpass_geo_id ON chpass_stat (geo_id);

-- Статистика по геозонам
DROP TABLE IF EXISTS geostat;
CREATE TABLE geostat (
  geo_id integer NOT NULL,
  day_total integer NOT NULL DEFAULT 0,
  day_ham integer NOT NULL DEFAULT 0,
  hour_total integer NOT NULL DEFAULT 0,
  hour_ham integer NOT NULL DEFAULT 0,
  PRIMARY KEY (geo_id)
);
-------------------------------------------------------------------------------
-- Справочные таблицы

---- Геозоны
DROP TABLE IF EXISTS geozones;
CREATE TABLE IF NOT EXISTS geozones (
  id serial NOT NULL,
  country char(2) NOT NULL,
  city varchar(120) DEFAULT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_geo;
CREATE UNIQUE INDEX index_geo ON geozones (country, city);
DROP INDEX IF EXISTS index_country;
CREATE INDEX IF NOT EXISTS index_country ON geozones (country);
DROP INDEX IF EXISTS index_city;
CREATE INDEX IF NOT EXISTS index_city ON geozones (city);

-- Белый список геозон
DROP TABLE IF EXISTS geostatwhite;
CREATE TABLE IF NOT EXISTS geostatwhite (
  geo_id integer NOT NULL,
  PRIMARY KEY (geo_id)
);

-- Группы геозон
DROP TABLE IF EXISTS geogroup;
CREATE TABLE IF NOT EXISTS geogroup (
  name varchar(120) NOT NULL,
  value text NOT NULL,
  PRIMARY KEY (name)
);

---- Автономные сети
DROP TABLE IF EXISTS ass;
CREATE TABLE IF NOT EXISTS ass (
  id serial NOT NULL,
  _as char(20) NOT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_as;
CREATE UNIQUE INDEX index_as ON ass (_as);

---- Типы регистраций
DROP TABLE IF EXISTS regtypes;
CREATE TABLE IF NOT EXISTS regtypes (
  id serial NOT NULL,
  regtype varchar(255) NOT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_regtype;
CREATE UNIQUE INDEX IF NOT EXISTS index_regtype ON regtypes (regtype);

---- Сервисы
DROP TABLE IF EXISTS services;
CREATE TABLE IF NOT EXISTS services (
  id serial NOT NULL,
  service varchar(255) NOT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_service;
CREATE UNIQUE INDEX IF NOT EXISTS index_service ON services (service);

---- Типы смены пароля
DROP TABLE IF EXISTS chpass_types;
CREATE TABLE IF NOT EXISTS chpass_types (
  id serial NOT NULL,
  chpass_type varchar(255) NOT NULL,
  PRIMARY KEY (id)
);
DROP INDEX IF EXISTS index_chpass_type;
CREATE UNIQUE INDEX IF NOT EXISTS index_chpass_type ON chpass_types (chpass_type);
-------------------------------------------------------------------------------
