#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys
import json
import pymongo

FOLDERTREE_PATH = '/opt/imapui/foldertree.json'
MONGO = {
    'uri':     "mongodb://compldb1j.so.yandex.net,compldb1m.so.yandex.net,compldb1o.so.yandex.net/imap",
    'port':    27017,
    'db':      'imap',
    'replset': 'compldb'
}

db = pymongo.MongoClient(host=MONGO['uri'], port=MONGO['port'], replicaSet=MONGO['replset'])[MONGO["db"]]
folders = json.loads(open(FOLDERTREE_PATH).read())

def saveNode(folder, parent = ''):
    if not 'id' in folder: return
    folder_id = folder['id']; del folder['id']
    nodes = []
    if 'nodes' in folder:
        for el in folder['nodes']: nodes.append(saveNode(el, folder_id))
        del folder['nodes']
    folder['parent'] = parent; folder['nodes'] = nodes
    db['folders'].update({'_id': folder_id}, {'$set': folder}, upsert = True)
    print folder_id + ' saved'
    return folder_id

for folder in folders:
    folder_id = folder['id']
    saveNode(folder)
