#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
import redis
from urllib import urlopen
from time import strftime
from datetime import datetime, timedelta
from traceback import format_exception

REDIS1 = {
    "cluster":  "mail_so_813",
    'hosts':   ['compldb1m.so.yandex.net', 'compldb1j.so.yandex.net', 'compldb1o.so.yandex.net'],
    'port':    6379,
    'db':      1,
    'timeout': 3.0
}
REDIS2 = {
    "cluster_name":  "imapchick",
    "hosts":         ['sas-9hj1mqfnn09ivo2p.db.yandex.net', 'vla-lypu9dngze8qheim.db.yandex.net', 'man-6v977wn0obbbwqw0.db.yandex.net'],
    "port":          6379,
    "sentinel_port": 26379,
    "db":            0,
    "timeout":       30.0,
    "auth":          True
}
WORKING_DIR = os.environ['HOME'] if 'HOME' in os.environ else '.'

global writelog

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

class writeLog():
    def __init__(self, log_file=None):
        self.fh = open(log_file, "a+t") if log_file and os.path.exists(log_file) else sys.stderr

    def __call__(self, msg, isTB=False, prefix='', isAddTS=True):
        if not msg:
            return
        try:
            tb = "\n"
            if isTB:
                tb += get_traceback()
            s = prefix + msg + tb
            if isAddTS:
                s = strftime("[%Y-%m-%d %H:%M:%S]: ") + s
            os.write(self.fh.fileno(), s)
        except Exception, e:
            print("Writelog error: %s.%s" % (str(e), get_traceback()), file=sys.stderr)
            sys.stderr.flush()

writelog = writeLog()

def doRequest(url, prompt):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            writelog('{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info()))
    except Exception, e:
        writelog('%s HTTP request failed: %s.' % (prompt, str(e)), True)
    return ""

def getRedisCredentials(cfg):
    f, CURDIR, dbname = None, WORKING_DIR, cfg['cluster_name'][:len(cfg['cluster_name']) - 2] if 'cluster_name' in cfg and cfg['cluster_name'].endswith('db') else cfg.get('cluster_name', '')
    try:
        if dbname:
            if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                CURDIR = os.path.dirname(os.path.abspath(__file__))
                if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                    CURDIR = '.'
            if os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                f = open('{0}/.redis.{1}'.format(CURDIR, dbname))
                for line in f:
                    sf = line.split(':')
                    if len(sf) == 1:
                        cfg['password'] = sf[0].strip()
                        break
                    elif len(sf) == 2 and sf[0] == cfg['cluster_name']:
                        cfg['cluster_name'], cfg['password'] = sf[0], sf[1].strip()
                        break
                f.close()
    except Exception, e:
        writelog("getRedisCredentials exception: %s" % str(e), True)

def redis_connect(host, port, cfg):
    if 'password' in cfg and cfg['password']:
        return redis.Redis(host=host, port=port, db=cfg['db'], password=cfg['password'], socket_timeout=cfg['timeout'])
    else:
        return redis.Redis(host=host, port=port, db=cfg['db'], socket_timeout=cfg['timeout'])

def redis_reconnect(cfg):
    rediscli = None
    try:
        if 'auth' in cfg and cfg['auth']:
            getRedisCredentials(cfg)
        else:
            cfg['password'] = None
        if 'host' in cfg and cfg['host']:
            rediscli = redis.Redis(host=cfg['host'], port=cfg['port'], db=cfg['db'], passport=cfg['password'], socket_timeout=cfg['timeout'])
        elif 'hosts' in cfg and cfg['hosts']:
            if 'cluster_name' in cfg and cfg['cluster_name']:
                try:
                    redis_sentinel = redis.Redis(host=cfg['hosts'][0], port=cfg.get('sentinel_port', 26379), socket_timeout=cfg['timeout'])
                    host = redis_sentinel.sentinel_get_master_addr_by_name(cfg['cluster_name'])
                    rediscli = redis_connect(host[0], host[1], cfg)
                except Exception, e:
                    writelog("Exception in redis_reconnect for cluster '%s': %s" % (cfg['cluster_name'], str(e)), True)
            else:
                for host in cfg['hosts']:
                    try:
                        rediscli = redis_connect(host, cfg['port'], cfg)
                        if rediscli.info()["role"] == "master":
                            return rediscli
                    except Exception, e:
                        writelog("Exception in redis_reconnect: %s" % str(e), True)
    except Exception, e:
        writelog("Exception while redis_reconnect: %s" % str(e), True)
    return rediscli

try:
    redis1 = redis_reconnect(REDIS1)
    redis2 = redis_reconnect(REDIS2)
    print("Start processing..."); sys.stdout.flush()
    for key in redis1.scan_iter("*"):
        print("Process key: %s " % key, end=''); sys.stdout.flush()
        if redis1.type(key) == 'hash':
            h = redis1.hgetall(key)
            redis2.hmset(key, h)
        elif redis1.type(key) == 'string':
            s = redis1.get(key)
            redis2.set(key, s)
        print("- done                       ", end='\r'); sys.stdout.flush()
    print("DONE                                                     "); sys.stdout.flush()
except Exception, e:
    writelog("Redis DB exception: %s" % str(e), True)
