-------------------------------------------------------------------------------
-- encoding: utf-8
-- kate: space-indent on; indent-width 2; replace-tabs on;
--
-------------------------------------------------------------------------------
-- Таблицы статистики правил

---- Таблица посуточной статистики правил сервиса проверки входящей почты
--DROP TABLE IF EXISTS rules_in CASCADE;
CREATE TABLE IF NOT EXISTS rules_in (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_in_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_in_index ON rules_in (rule, "date");
--DROP INDEX IF EXISTS rules_in_index_r1;
CREATE INDEX IF NOT EXISTS rules_in_index_r1 ON rules_in (R1);
--DROP INDEX IF EXISTS rules_in_index_r2;
CREATE INDEX IF NOT EXISTS rules_in_index_r2 ON rules_in (R2);
--DROP INDEX IF EXISTS rules_in_index_r4;
CREATE INDEX IF NOT EXISTS rules_in_index_r4 ON rules_in (R4);
--DROP INDEX IF EXISTS rules_in_index_r8;
CREATE INDEX IF NOT EXISTS rules_in_index_r8 ON rules_in (R8);
--DROP INDEX IF EXISTS rules_in_index_r127;
CREATE INDEX IF NOT EXISTS rules_in_index_r127 ON rules_in (R127);
--DROP INDEX IF EXISTS rules_in_index_r256;
CREATE INDEX IF NOT EXISTS rules_in_index_r256 ON rules_in (R256);
--DROP INDEX IF EXISTS rules_in_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS rules_in_index_cmpl_spam ON rules_in (cmpl_spam);
--DROP INDEX IF EXISTS rules_in_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS rules_in_index_cmpl_ham ON rules_in (cmpl_ham);
--DROP INDEX IF EXISTS rules_in_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS rules_in_index_cmpl_spam_nopf ON rules_in (cmpl_spam_nopf);
--DROP INDEX IF EXISTS rules_in_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS rules_in_index_cmpl_ham_nopf ON rules_in (cmpl_ham_nopf);

---- Таблица по-10-минутной статистики правил сервиса проверки входящей почты
--DROP TABLE IF EXISTS detailed_rules_in CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_in (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_in_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_in_index ON detailed_rules_in (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_in_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r1 ON detailed_rules_in (R1);
--DROP INDEX IF EXISTS detailed_rules_in_index_r2;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r2 ON detailed_rules_in (R2);
--DROP INDEX IF EXISTS detailed_rules_in_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r4 ON detailed_rules_in (R4);
--DROP INDEX IF EXISTS detailed_rules_in_index_r8;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r8 ON detailed_rules_in (R8);
--DROP INDEX IF EXISTS detailed_rules_in_index_r127;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r127 ON detailed_rules_in (R127);
--DROP INDEX IF EXISTS detailed_rules_in_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r256 ON detailed_rules_in (R256);
--DROP INDEX IF EXISTS detailed_rules_in_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_cmpl_spam ON detailed_rules_in (cmpl_spam);
--DROP INDEX IF EXISTS detailed_rules_in_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_cmpl_ham ON detailed_rules_in (cmpl_ham);
--DROP INDEX IF EXISTS detailed_rules_in_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_cmpl_spam_nopf ON detailed_rules_in (cmpl_spam_nopf);
--DROP INDEX IF EXISTS detailed_rules_in_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_cmpl_ham_nopf ON detailed_rules_in (cmpl_ham_nopf);

---- Таблица посуточной статистики правил сервиса проверки исходящей почты
--DROP TABLE IF EXISTS rules_out CASCADE;
CREATE TABLE IF NOT EXISTS rules_out (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_out_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_out_index ON rules_out (rule, "date");
--DROP INDEX IF EXISTS rules_out_index_r1;
CREATE INDEX IF NOT EXISTS rules_out_index_r1 ON rules_out (R1);
--DROP INDEX IF EXISTS rules_out_index_r2;
CREATE INDEX IF NOT EXISTS rules_out_index_r2 ON rules_out (R2);
--DROP INDEX IF EXISTS rules_out_index_r4;
CREATE INDEX IF NOT EXISTS rules_out_index_r4 ON rules_out (R4);
--DROP INDEX IF EXISTS rules_out_index_r8;
CREATE INDEX IF NOT EXISTS rules_out_index_r8 ON rules_out (R8);
--DROP INDEX IF EXISTS rules_out_index_r127;
CREATE INDEX IF NOT EXISTS rules_out_index_r127 ON rules_out (R127);
--DROP INDEX IF EXISTS rules_out_index_r256;
CREATE INDEX IF NOT EXISTS rules_out_index_r256 ON rules_out (R256);
--DROP INDEX IF EXISTS rules_out_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS rules_out_index_cmpl_spam ON rules_out (cmpl_spam);
--DROP INDEX IF EXISTS rules_out_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS rules_out_index_cmpl_ham ON rules_out (cmpl_ham);
--DROP INDEX IF EXISTS rules_out_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS rules_out_index_cmpl_spam_nopf ON rules_out (cmpl_spam_nopf);
--DROP INDEX IF EXISTS rules_out_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS rules_out_index_cmpl_ham_nopf ON rules_out (cmpl_ham_nopf);

---- Таблица по-10-минутной статистики правил сервиса проверки исходящей почты
--DROP TABLE IF EXISTS detailed_rules_out CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_out (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_out_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_out_index ON detailed_rules_out (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_out_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_r1 ON detailed_rules_out (R1);
--DROP INDEX IF EXISTS detailed_rules_out_index_r2;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_r2 ON detailed_rules_out (R2);
--DROP INDEX IF EXISTS detailed_rules_out_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_r4 ON detailed_rules_out (R4);
--DROP INDEX IF EXISTS detailed_rules_out_index_r8;
CREATE INDEX IF NOT EXISTS detailed_rules_in_index_r8 ON detailed_rules_out (R8);
--DROP INDEX IF EXISTS detailed_rules_out_index_r127;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_r127 ON detailed_rules_out (R127);
--DROP INDEX IF EXISTS detailed_rules_out_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_r256 ON detailed_rules_out (R256);
--DROP INDEX IF EXISTS detailed_rules_out_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_cmpl_spam ON detailed_rules_out (cmpl_spam);
--DROP INDEX IF EXISTS detailed_rules_out_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_cmpl_ham ON detailed_rules_out (cmpl_ham);
--DROP INDEX IF EXISTS detailed_rules_out_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_cmpl_spam_nopf ON detailed_rules_out (cmpl_spam_nopf);
--DROP INDEX IF EXISTS detailed_rules_out_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_out_index_cmpl_ham_nopf ON detailed_rules_out (cmpl_ham_nopf);

---- Таблица посуточной статистики правил сервиса проверки корпоративной почты
--DROP TABLE IF EXISTS rules_corp CASCADE;
CREATE TABLE IF NOT EXISTS rules_corp (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_corp_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_corp_index ON rules_corp (rule, "date");
--DROP INDEX IF EXISTS rules_corp_index_r1;
CREATE INDEX IF NOT EXISTS rules_corp_index_r1 ON rules_corp (R1);
--DROP INDEX IF EXISTS rules_corp_index_r2;
CREATE INDEX IF NOT EXISTS rules_corp_index_r2 ON rules_corp (R2);
--DROP INDEX IF EXISTS rules_corp_index_r4;
CREATE INDEX IF NOT EXISTS rules_corp_index_r4 ON rules_corp (R4);
--DROP INDEX IF EXISTS rules_corp_index_r8;
CREATE INDEX IF NOT EXISTS rules_corp_index_r8 ON rules_corp (R8);
--DROP INDEX IF EXISTS rules_corp_index_r127;
CREATE INDEX IF NOT EXISTS rules_corp_index_r127 ON rules_corp (R127);
--DROP INDEX IF EXISTS rules_corp_index_r256;
CREATE INDEX IF NOT EXISTS rules_corp_index_r256 ON rules_corp (R256);
--DROP INDEX IF EXISTS rules_corp_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS rules_corp_index_cmpl_spam ON rules_corp (cmpl_spam);
--DROP INDEX IF EXISTS rules_corp_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS rules_corp_index_cmpl_ham ON rules_corp (cmpl_ham);
--DROP INDEX IF EXISTS rules_corp_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS rules_corp_index_cmpl_spam_nopf ON rules_corp (cmpl_spam_nopf);
--DROP INDEX IF EXISTS rules_corp_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS rules_corp_index_cmpl_ham_nopf ON rules_corp (cmpl_ham_nopf);

---- Таблица по-10-минутной статистики правил сервиса проверки корпоративной почты
--DROP TABLE IF EXISTS detailed_rules_corp CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_corp (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R2 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R8 BIGINT NOT NULL DEFAULT 0,
  R127 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  cmpl_spam BIGINT NOT NULL DEFAULT 0,
  cmpl_spam_nopf BIGINT NOT NULL DEFAULT 0,
  cmpl_ham BIGINT NOT NULL DEFAULT 0,
  cmpl_ham_nopf BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_corp_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_corp_index ON detailed_rules_corp (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_corp_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r1 ON detailed_rules_corp (R1);
--DROP INDEX IF EXISTS detailed_rules_corp_index_r2;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r2 ON detailed_rules_corp (R2);
--DROP INDEX IF EXISTS detailed_rules_corp_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r4 ON detailed_rules_corp (R4);
--DROP INDEX IF EXISTS detailed_rules_corp_index_r8;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r8 ON detailed_rules_corp (R8);
--DROP INDEX IF EXISTS detailed_rules_corp_index_r127;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r127 ON detailed_rules_corp (R127);
--DROP INDEX IF EXISTS detailed_rules_corp_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_r256 ON detailed_rules_corp (R256);
--DROP INDEX IF EXISTS detailed_rules_corp_index_cmpl_spam;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_cmpl_spam ON detailed_rules_corp (cmpl_spam);
--DROP INDEX IF EXISTS detailed_rules_corp_index_cmpl_ham;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_cmpl_ham ON detailed_rules_corp (cmpl_ham);
--DROP INDEX IF EXISTS detailed_rules_corp_index_cmpl_spam_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_cmpl_spam_nopf ON detailed_rules_corp (cmpl_spam_nopf);
--DROP INDEX IF EXISTS detailed_rules_corp_index_cmpl_ham_nopf;
CREATE INDEX IF NOT EXISTS detailed_rules_corp_index_cmpl_ham_nopf ON detailed_rules_corp (cmpl_ham_nopf);

---- Таблица посуточной статистики правил сервиса проверки поиска по почте
--DROP TABLE IF EXISTS rules_sosearch CASCADE;
CREATE TABLE IF NOT EXISTS rules_sosearch (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_sosearch_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_sosearch_index ON rules_sosearch (rule, "date");
--DROP INDEX IF EXISTS rules_sosearch_index_r1;
CREATE INDEX IF NOT EXISTS rules_sosearch_index_r1 ON rules_sosearch (R1);
--DROP INDEX IF EXISTS rules_sosearch_index_r4;
CREATE INDEX IF NOT EXISTS rules_sosearch_index_r4 ON rules_sosearch (R4);
--DROP INDEX IF EXISTS rules_sosearch_index_r256;
CREATE INDEX IF NOT EXISTS rules_sosearch_index_r256 ON rules_sosearch (R256);

---- Таблица по-10-минутной статистики правил сервиса проверки поиска по почте
--DROP TABLE IF EXISTS detailed_rules_sosearch CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_sosearch (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_sosearch_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_sosearch_index ON detailed_rules_sosearch (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_sosearch_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_sosearch_index_r1 ON detailed_rules_sosearch (R1);
--DROP INDEX IF EXISTS detailed_rules_sosearch_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_sosearch_index_r4 ON detailed_rules_sosearch (R4);
--DROP INDEX IF EXISTS detailed_rules_sosearch_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_sosearch_index_r256 ON detailed_rules_sosearch (R256);

---- Таблица посуточной статистики правил сервиса проверки регистраций в пасспорте
--DROP TABLE IF EXISTS rules_sopassport CASCADE;
CREATE TABLE IF NOT EXISTS rules_sopassport (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_sopassport_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_sopassport_index ON rules_sopassport (rule, "date");
--DROP INDEX IF EXISTS rules_sopassport_index_r1;
CREATE INDEX IF NOT EXISTS rules_sopassport_index_r1 ON rules_sopassport (R1);
--DROP INDEX IF EXISTS rules_sopassport_index_r4;
CREATE INDEX IF NOT EXISTS rules_sopassport_index_r4 ON rules_sopassport (R4);
--DROP INDEX IF EXISTS rules_sopassport_index_r256;
CREATE INDEX IF NOT EXISTS rules_sopassport_index_r256 ON rules_sopassport (R256);

---- Таблица по-10-минутной статистики правил сервиса проверки регистраций в пасспорте
--DROP TABLE IF EXISTS detailed_rules_sopassport CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_sopassport (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_sopassport_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_sopassport_index ON detailed_rules_sopassport (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_sopassport_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_sopassport_index_r1 ON detailed_rules_sopassport (R1);
--DROP INDEX IF EXISTS detailed_rules_sopassport_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_sopassport_index_r4 ON detailed_rules_sopassport (R4);
--DROP INDEX IF EXISTS detailed_rules_sopassport_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_sopassport_index_r256 ON detailed_rules_sopassport (R256);

---- Таблица посуточной статистики правил сервиса проверки форм
--DROP TABLE IF EXISTS rules_socheckform CASCADE;
CREATE TABLE IF NOT EXISTS rules_socheckform (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_socheckform_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_socheckform_index ON rules_socheckform (rule, "date");
--DROP INDEX IF EXISTS rules_socheckform_index_r1;
CREATE INDEX IF NOT EXISTS rules_socheckform_index_r1 ON rules_socheckform (R1);
--DROP INDEX IF EXISTS rules_socheckform_index_r4;
CREATE INDEX IF NOT EXISTS rules_socheckform_index_r4 ON rules_socheckform (R4);
--DROP INDEX IF EXISTS rules_socheckform_index_r256;
CREATE INDEX IF NOT EXISTS rules_socheckform_index_r256 ON rules_socheckform (R256);

---- Таблица по-10-минутной статистики правил сервиса проверки форм
--DROP TABLE IF EXISTS detailed_rules_socheckform CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_socheckform (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_socheckform_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_socheckform_index ON detailed_rules_socheckform (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_socheckform_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckform_index_r1 ON detailed_rules_socheckform (R1);
--DROP INDEX IF EXISTS detailed_rules_socheckform_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckform_index_r4 ON detailed_rules_socheckform (R4);
--DROP INDEX IF EXISTS detailed_rules_socheckform_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckform_index_r256 ON detailed_rules_socheckform (R256);

---- Таблица посуточной статистики правил сервиса проверки коротких сообщений
--DROP TABLE IF EXISTS rules_socheckmessages CASCADE;
CREATE TABLE IF NOT EXISTS rules_socheckmessages (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_socheckmessages_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_socheckmessages_index ON rules_socheckmessages (rule, "date");
--DROP INDEX IF EXISTS rules_socheckmessages_index_r1;
CREATE INDEX IF NOT EXISTS rules_socheckmessages_index_r1 ON rules_socheckmessages (R1);
--DROP INDEX IF EXISTS rules_socheckmessages_index_r4;
CREATE INDEX IF NOT EXISTS rules_socheckmessages_index_r4 ON rules_socheckmessages (R4);
--DROP INDEX IF EXISTS rules_socheckmessages_index_r256;
CREATE INDEX IF NOT EXISTS rules_socheckmessages_index_r256 ON rules_socheckmessages (R256);

---- Таблица по-10-минутной статистики правил сервиса проверки коротких сообщений
--DROP TABLE IF EXISTS detailed_rules_socheckmessages CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_socheckmessages (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_socheckmessages_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_socheckmessages_index ON detailed_rules_socheckmessages (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_socheckmessages_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckmessages_index_r1 ON detailed_rules_socheckmessages (R1);
--DROP INDEX IF EXISTS detailed_rules_socheckmessages_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckmessages_index_r4 ON detailed_rules_socheckmessages (R4);
--DROP INDEX IF EXISTS detailed_rules_socheckmessages_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_socheckmessages_index_r256 ON detailed_rules_socheckmessages (R256);

---- Таблица посуточной статистики правил сервиса репутаций IP-адресов
--DROP TABLE IF EXISTS rules_sostatip CASCADE;
CREATE TABLE IF NOT EXISTS rules_sostatip (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "date" DATE NOT NULL DEFAULT CURRENT_DATE,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS rules_sostatip_index;
CREATE UNIQUE INDEX IF NOT EXISTS rules_sostatip_index ON rules_sostatip (rule, "date");
--DROP INDEX IF EXISTS rules_sostatip_index_r1;
CREATE INDEX IF NOT EXISTS rules_sostatip_index_r1 ON rules_sostatip (R1);
--DROP INDEX IF EXISTS rules_sostatip_index_r4;
CREATE INDEX IF NOT EXISTS rules_sostatip_index_r4 ON rules_sostatip (R4);
--DROP INDEX IF EXISTS rules_sostatip_index_r256;
CREATE INDEX IF NOT EXISTS rules_sostatip_index_r256 ON rules_sostatip (R256);

---- Таблица по-10-минутной статистики правил сервиса репутаций IP-адресов
--DROP TABLE IF EXISTS detailed_rules_sostatip CASCADE;
CREATE TABLE IF NOT EXISTS detailed_rules_sostatip (
  id BIGSERIAL NOT NULL,
  rule VARCHAR(128) DEFAULT NULL,
  R1 BIGINT NOT NULL DEFAULT 0,
  R4 BIGINT NOT NULL DEFAULT 0,
  R256 BIGINT NOT NULL DEFAULT 0,
  "time" TIMESTAMPTZ NOT NULL DEFAULT LOCALTIMESTAMP,
  PRIMARY KEY (id)
);
--DROP INDEX IF EXISTS detailed_rules_sostatip_index;
CREATE UNIQUE INDEX IF NOT EXISTS detailed_rules_sostatip_index ON detailed_rules_sostatip (rule, "time");
--DROP INDEX IF EXISTS detailed_rules_sostatip_index_r1;
CREATE INDEX IF NOT EXISTS detailed_rules_sostatip_index_r1 ON detailed_rules_sostatip (R1);
--DROP INDEX IF EXISTS detailed_rules_sostatip_index_r4;
CREATE INDEX IF NOT EXISTS detailed_rules_sostatip_index_r4 ON detailed_rules_sostatip (R4);
--DROP INDEX IF EXISTS detailed_rules_sostatip_index_r256;
CREATE INDEX IF NOT EXISTS detailed_rules_sostatip_index_r256 ON detailed_rules_sostatip (R256);

---- Таблица для регулирования работы скриптов, запускаемых по крону, которые обслуживают БД
--DROP TABLE IF EXISTS cron_scripts;
CREATE TABLE IF NOT EXISTS cron_scripts (
  id VARCHAR(32),
  last_start_ts TIMESTAMP DEFAULT LOCALTIMESTAMP,
  last_end_ts TIMESTAMP,
  cron_expr VARCHAR(100), -- https://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/obshayaformula/fml/reactiveconveyor/triggers/cron/
  options TEXT NOT NULL DEFAULT '',
  PRIMARY KEY (id, cron_expr)
);
-------------------------------------------------------------------------------
