#!/usr/bin/env python2.7
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
from collections import defaultdict
from common import *
from db import loadMongoDbCredentials, getMongoDB

__author__ = "Yaroslav Klimik <klimiky@yandex-team.ru>"
__version__ = "1.0"

MONGO = {
    'cluster': 'so_db',
    'db':      'solog',
    'hosts':   'db1j.so.yandex.net,db1m.so.yandex.net,db1h.so.yandex.net',
    'port':    27017,
    'user':    'solog',
    'timeout': 60000
}
loadMongoDbCredentials(MONGO)
route = (sys.argv[1] if len(sys.argv) > 1 else 'in').lower()
detailed = defaultdict(lambda: defaultdict(lambda: defaultdict(int)))
daily = defaultdict(lambda: defaultdict(lambda: defaultdict(int)))
try:
    db = getMongoDB(MONGO)
    for record in db['Rules_%s' % route].find():
        for key in record.keys():
            if key in ['_id', 'rule', 'date']:
                continue
            daily[record['date']][record['rule']][key] = record[key]
    for record in db['detailed_Rules_%s' % route].find():
        for key in record.keys():
            if key in ['_id', 'rule', 'time']:
                continue
            detailed[record['time']][record['rule']][key] = record[key]
except Exception, e:
    writelog("Exception '%s' while retrieving record: %s" % (str(e), record), True, sys.stderr)

route = route.capitalize()
try:
    for (d, rules_stat) in daily.iteritems():
        for (rule, stat) in rules_stat.iteritems():
            db['Rules_%s' % route].update_one({'rule': rule, 'date': d}, {'$inc': dict(stat)}, upsert=True)
    for (t, rule_stat) in detailed.iteritems():
        for (rule, stat) in rule_stat.iteritems():
            db['detailed_Rules_%s' % route].update_one({'rule': rule, 'time': t}, {'$inc': dict(stat)}, upsert=True)
except Exception, e:
    writelog("Exception while saving data: %s" % str(e), True, sys.stderr)
