#!/usr/bin/python

import datetime


RESOURCE_NAME = "sp-daemon"


def get_resources_chunk(chunk_size):
    now = datetime.datetime.utcnow()
    since = now - datetime.timedelta(days=10 * 365)
    #till = now - datetime.timedelta(days=14)
    till = now - datetime.timedelta(days=366)

    return api.resource.read(
        owner="MAIL_SO",
        type="YA_PACKAGE",
        attrs={"resource_name": RESOURCE_NAME},
        state="READY",
        created="{}..{}".format(since.isoformat(), till.isoformat()),
        #created="..{}".format(till.isoformat()),
        limit=chunk_size,
    )


def replace_attribute(i, total, rid, key, value):
    print("Set attribute {}={} for resource ({} of {}): {}".format(key, value, i, total, rid))
    api.resource[rid].attribute[key] = {"value": value}


def remove_some_resources(limit):
    resp = get_resources_chunk(limit)
    print("Removing", len(resp["items"]), "resource out of", resp["total"])
    i = 0
    for res in resp["items"]:
        i += 1
        if res["attributes"].get("ttl") == "inf":
            # Drop infinite ttl to allow deleting of resource
            replace_attribute(i, resp["total"], res["id"], "ttl", "14")

    ids = [_["id"] for _ in resp["items"]]
    print("Removing resources: ", ids)
    api.batch.resources["delete"].update(
        id=ids,
        comment="Remove extra resources",
    )
