#!/usr/bin/env python2.7
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys, re, json, pymongo
from time import strftime
from urllib import urlopen
from traceback import format_exception

CFG = {
    "retry_cnt": 3,
    "home_dir":  os.environ["HOME"] if "HOME" in os.environ else "/root"
}
HOSTS = ["statlog{}.so.yandex.net".format(k) for k in ['h', 'f', 'g', 'm', 'o', 'p', '01e', '02e', '01h', '02h', '01f', '02f']]
MONGO = {
    'db':      'rules',
    'hosts':   'sas-8bydc7gbz3h070ke.db.yandex.net,vla-hwmeehtmq450wvke.db.yandex.net,man-t5y0rvgx2wm1mer4.db.yandex.net',
    'port':    27018,
    'user':    'solog',
    'timeout': 60000
}

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def writelog(msg, isTB=False, fh=None, prefix='', isAddTS=True):
    if not msg:
        return
    if not fh:
        fh = sys.stderr
    try:
        tb = "\n"
        if isTB:
            tb += get_traceback()
        s = prefix + msg + tb
        if isAddTS:
            s = strftime("[%Y-%m-%d %H:%M:%S]: ") + s
        os.write(fh.fileno(), s)
    except Exception, e:
        print("Writelog error: %s.%s" % (str(e), get_traceback()), file=sys.stderr)
        sys.stderr.flush()

def doRequest(url, prompt="doRequest"):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            writelog('{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info()))
    except Exception, e:
        writelog('%s HTTP request failed: %s.\n' % (prompt, str(e)), True)
    return ""

def getHosts4Group(conductor_group, default_hosts=[]):
    if conductor_group:
        for i in range(CFG["retry_cnt"]):
            r = doRequest("https://c.yandex-team.ru/api-cached/groups2hosts/%s" % conductor_group, "Get DB cluster hosts for group %s" % conductor_group)
            if r:
                hosts = map(str.strip, r.splitlines())
                return hosts if len(hosts) > 0 else default_hosts
            else:
                continue
    return default_hosts

def mongo_conn_str(cfg):
    s, hosts = '', cfg.get('hosts', '127.0.0.1').split(',')
    if 'user' in cfg and cfg['user']:
        s = "%s:%s@" % (cfg['user'], cfg['passwd'])
    return "mongodb://%s%s/%s" % (s, ','.join(getHosts4Group(cfg.get('cluster', ''), cfg['hosts'].split(','))), cfg['db'])

def loadMongoDbCredentials(cfg):
    f, CURDIR = None, CFG["home_dir"]
    try:
        if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])) and 'HOME' in os.environ:
                CURDIR = os.environ['HOME']
        if os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            f = open('%s/.mongodb.%s' % (CURDIR, cfg['db']))
            for line in f:
                sf = line.split(':')
                if len(sf) == 2:
                    cfg['user'], cfg['passwd'] = sf[0], sf[1].strip()
                    break
            f.close()
        elif 'user' in cfg:
            writelog("ERROR: Unable to locate file with DB credentials!")
    except Exception, e:
        writelog("loadMongoDbCredentials exception: %s" % str(e), True)

def getMongoDB(cfg):
    if not hasattr(getMongoDB, "%s_connection" % cfg['db']):
        timeout = cfg['timeout'] if 'timeout' in cfg and cfg['timeout'] else 10000
        setattr(getMongoDB, "%s_connection" % cfg['db'], pymongo.MongoClient(host=mongo_conn_str(cfg), port=cfg['port'], connectTimeoutMS=timeout, socketTimeoutMS=timeout)[cfg['db']])
    return getattr(getMongoDB, "%s_connection" % cfg['db'])

if __name__ == "__main__":
    #loadMongoDbCredentials(MONGO)
    #db = getMongoDB(MONGO)
    #for collection in db.collection_names(False):
    #    collection.ensure_index("rcpt_uid")
    for host in getHosts4Group("so_statlog", HOSTS):
        print("Host: %s" % host)
        mongo_cfg = {"db": "solog", "hosts": host, "port": 27017, "timeout": 90000}
        db = getMongoDB(mongo_cfg)
        for collection_name in db.collection_names(False):
            print("\t%s: " % collection_name, end='')
            db[collection_name].ensure_index("rcpt_uid")
            print("done")
