#!/bin/bash
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
ROUTE=${1:-in}
ENV_NAME=
if [ -e './environment.name' ]; then
  ENV_NAME=$(cat ./environment.name)
elif [ -e '/etc/environment.name' ]; then
  ENV_NAME=$(cat /etc/environment.name)
fi
[ -n "$ENV_NAME" ] && ROUTE=${ENV_NAME#so}

for log in ADV AUTORU CALENDAR DISK FEEDBACK FORMS_BACK_DEV FURITA GEOCHATS JOB MARKET MOIKRUG PAYMENT POSTCARD REALTY UNKNOWN XMPP YAPHOTO YARU YAUSLUGI; do
  DELIVERY_LOG=LOG_DIR/$log/delivery.log
  [ -e $DELIVERY_LOG ] && [ -f $DELIVERY_LOG ] || continue
  PARSER_DIR/so-deliverylog-parser.py PARSER_DIR/so-deliverylog-parser.ini $ROUTE $DELIVERY_LOG Socheckform_$log >> ERRORLOG_DIR/parser-errors.log 2>&1
done

