#!/bin/bash
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
ROUTE=${1:-in}
ENV_NAME=
if [ -e './environment.name' ]; then
  ENV_NAME=$(cat ./environment.name)
elif [ -e '/etc/environment.name' ]; then
  ENV_NAME=$(cat /etc/environment.name)
fi
[ -n "$ENV_NAME" ] && ROUTE=${ENV_NAME#so}

INI_FILE=PARSER_DIR/so-deliverylog-parser.ini
[ ! -e "$INI_FILE" ] && INI_FILE=PARSER_DIR/so-deliverylog-parser-${ROUTE}.ini

PARSER_DIR/so-deliverylog-parser.py $INI_FILE $ROUTE >> ERRORLOG_DIR/deliverylog-parser-errors.log 2>&1
