#!/bin/bash
# -*- Encoding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
### BEGIN INIT INFO
# Provides:          frodo_stat
# Required-Start:    $local_fs $network $remote_fs $syslog
# Required-Stop:     $local_fs $network $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Frodooborona statistics system: UI subsystem
# Description:       Frodooborona statistics system consists of to parts:
#                    subsystem of log parsing and subsystem of Frodooborona's web-interface (UI).
#                    Backend of log parsing subsystem uses RDBMS PGaaS.
### END INIT INFO

# Author: Yaroslav Klimik <klimiky@yandex-team.ru>

# Do NOT "set -e"
RETVAL=0

PATH=/sbin:/usr/sbin:/bin:/usr/bin
RETVAL=0
BINARY="/opt/frodo_stat/ui/frodo_stat.py"
PROG=$(basename $BINARY)
PROG_NAME=$(tr '[:lower:]' '[:upper:]' <<< $PROG)

PIDFILE="/var/run/frodo_stat.pid"
LOGFILE="/var/log/so-logs/frodo_stat.log"

# Exit if the package is not installed
[ -x "$BINARY" ] || exit 0

# Load the VERBOSE setting and other rcS variables
#. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.2-14) to ensure that this file is present
# and status_of_proc is working.
#. /lib/lsb/init-functions

#
# Helper functions for beautifying output
#
RES_COL=60
MOVE_TO_COL="echo -en \\033[${RES_COL}G"
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

success() {
    local str=${1:-OK} s=" " l=0
    (( l=6-${#str}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_SUCCESS}
    echo -n "${s}$str"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 0
}

failure() {
    local errstr=${1:-FAILED} s=" " l=0
    (( l=6-${#errstr}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_FAILURE}
    echo -ne "${s}$errstr"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 1
}

warning() {
    local warn=${1:-WARNING} s=" " l=0
    (( l=6-${#warn}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_WARNING}
    echo -ne "${s}$warn"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 1
}

check_server() {
    local MPID MC
    if [ -f "$PIDFILE" ]; then
        MPID=`cat ${PIDFILE}`
        if [ -n "$MPID" ]; then
            MC=`ps ax | grep $BINARY | grep $MPID | wc -l`
            if  [ $MC -gt 0 ]; then return 0
            elif [ $MC -eq 0 ]; then return 1; fi
        fi
    else
        MC=`ps ax | grep $BINARY | grep -v grep | wc -l`
        if [ $MC -gt 0 ]; then
            return 2
        else
            return 1
        fi
    fi
    return 3;
}

start() {
    check_server
    RETVAL=$?
    if [ $RETVAL -gt 1 ]; then
        echo "Warning: At least one instance of the server is already running. Will be started another instance!"
        RETVAL=1; failure; echo
    else
        echo -n "Starting $PROG..."
        $BINARY >> $LOGFILE 2>&1
        RETVAL=$?
        if [ "$RETVAL" -ne "0" ]; then
            failure
        else
            success
        fi; echo
    fi
    return $RETVAL
}

stop() {
    echo -n "Stopping $PROG..."
    if [ ! -f $PIDFILE ]; then
        warning "Process not running"; echo
        return 1
    fi
    PROCESS_PID=$(cat $PIDFILE)
    rm -f $PIDFILE
    kill $PROCESS_PID
    for i in `seq 1 15`; do
        kill -0 $PROCESS_PID 2>/dev/null
        if [ $? -ne 0 ]; then
            success "OK"; echo
            return 0
        fi
        sleep 1
    done
    echo "Process not stopped. Killing..."
    kill -9 $PROCESS_PID
    success "OK"; echo
    return 0
}

server_status() {
    check_server
    local RC=$?
    echo -n "Process $PROG "
    if [ "$RC" -eq "0" ]; then
        echo -e "\033[1;32mis running\033[0;39m"
        return 0
    elif [ "$RC" -eq "1" ]; then
        echo -e "\033[1;31mis not running\033[0;39m"
    elif [ "$RC" -eq "2" ]; then
        echo -e "is \033[1;31mprobably running\033[0;39m, but PID-file \033[1;31does not exist\033[0;39m"
    else:
        echo -e "status \033[1;31mis undetermined\033[0;39m"
    fi
    return 1
}

case "$1" in
    status)
        server_status; RETVAL=$?
    ;;
    start)
        start; RETVAL=$?
    ;;
    stop)
        stop; RETVAL=$?
    ;;
    restart)
        stop; RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            sleep 0.1; start; RETVAL=$?
        fi
    ;;
    *)
      echo "Usage: $0 {start|stop|restart|status}"
      exit 2
  ;;
esac
exit $RETVAL
