#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, email
from datetime import datetime
from common import ALARM_PERIOD, loggerFLP, sendEmail

ALARMER_EMAILS = [ "sgeorge@yandex-team.ru", "klimiky@yandex-team.ru" ]
lastcall = None

def sendAlarmer(subject, body):
    global lastcall
    if lastcall and (datetime.today() - lastcall).seconds < ALARM_PERIOD:
        return
    lastcall = datetime.today()
    alarmer_file = os.path.join(os.path.dirname(__file__), 'alarmer.py')
    loggerFLP.trace('Send alarmer by script %s' % alarmer_file)
    msg = email.message_from_string(body.encode("utf-8"))
    msg['Content-Type'] = 'Content-Type: text/plain; charset=utf-8'
    msg['From'] = 'noreplay@yandex-team.ru'
    msg['To'] = ", ".join(ALARMER_EMAILS)
    msg['Subject'] = sys.argv[1].encode("utf-8")
    sendEmail(msg.as_string(), toaddr=msg['To'])
