#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys, time, psycopg2
from traceback import format_exception
from smtplib import SMTP
from datetime import datetime
from socket import gethostname

DELIVERY_LOG_MASK = "/u0/{0}/usr/local/www/logs/SO_FRODOOBORONA/delivery.log".format(gethostname())
SENDANSWER_LOG_MASK = "/u0/{0}/usr/local/www/logs/SO_FRODOOBORONA/sendanswer.log".format(gethostname())
FRODOLOG_CHARSET = "cp1251"

LOGFILE = '/var/log/so-logs/frodo_stat.log'
FRODO_STAT_LOG = '/var/log/so-logs/frodo-stat.log'
FRODO_LOGPARSE_LOG = '/var/log/so-logs/frodo-logparse.log'
FRODO_LOGPARSE_POS = '/opt/frodo_stat/frodo_logparse.pos'
PARSE_PERIOD = 180
UPDATE_PERIOD = 30
ALARM_PERIOD = 900
MAX_DB_CONNECTION_ATTEMPTS = 10
MAX_LOGINS_COUNT = 5000
SPAM_FROM_GOOD_ALARM_BOUNDARY = 25
CFG = {
    # Some predefined emails
    'robot':        'Robot Mailspam <robot-mailspam@yandex-team.ru>',
    'report':       'so-report@yandex-team.ru',
    # SMTP settings
    'smtp_host':    "outbound-relay.yandex.net",
    'smtp_port':    25,
    'smtp_timeout': 5.0
}
PG = {
    "host":    "so-frodo-statdb01e.db.yandex.net,so-frodo-statdb01f.db.yandex.net,sas-vknw0n81pw74pdkv.db.yandex.net",
    "port":    6432,
    "db":      "so_frodo_statdb",
    "user":    "so_frodo",
    "charset": "cp1251"
}

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def getCredentials():
    HOME_DIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
    if not os.path.exists('{0}/.pgpass.frodo_stat'.format(HOME_DIR)):
        HOME_DIR = os.path.dirname(os.path.abspath(__file__))
    f = open(HOME_DIR + '/.pgpass.frodo_stat')
    for line in f:
        sf = line.split(':')
        if len(sf) == 1:
            PG['passwd'] = sf[0].strip()
            break
        elif len(sf) == 2 and sf[0] == PG['user']:
            PG['passwd'] = sf[1].strip()
        elif len(sf) == 5 and sf[0] == PG['host'] and int(sf[1]) == PG['port'] and sf[2] == PG['db']:
            PG['user'], PG['passwd'] = sf[3].strip(), sf[4].strip()
            break
    f.close()

def writePid(PIDFILE):
    print >> open(PIDFILE, "wt"), os.getpid()

def to_utf8(data, default = ''):
    try:
        return data.encode("utf-8", "ignore")
    except UnicodeDecodeError:
        try:
            return "".join(map(lambda c: unichr(ord(c)), data))
        except:
            return default

class log:
    def __init__(self, filename = '', level = ''):
        self.filename = filename
        self.level = level
        try:
            self.f = open(self.filename, 'at')
        except Exception, e:
            print >>sys.stderr, "Unable open file '%s': %s" % (filename, str(e))

    def __del__(self):
        if self.f and not self.f.closed:
            self.f.close()

    def __call__(self, msg, isTB = False, level = ''):
        if not self.filename or not self.f:
            return
        print >>self.f, u"[%s]%s %s%s" % (datetime.today().strftime("%Y-%m-%d %H:%M:%S"), u" %s" % level if level else '', to_utf8(msg), u"\n%s" % get_traceback() if isTB else '')
        self.f.flush()

    def log(self, msg, isTB = False):
        self.__call__(msg, isTB, self.level)

    def trace(self, msg, isTB = False):
        self.__call__(msg, isTB, 'INFO')

    def error(self, msg, isTB = False):
        self.__call__(msg, isTB, 'ERR')

loggerFS = log(FRODO_STAT_LOG)
loggerFLP = log(FRODO_LOGPARSE_LOG)

def getPGdb(cfg, mode = 'read-write'):
    CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
    if not os.path.exists('%s/.pgsql/root.crt' % CURDIR):
        CURDIR = os.path.dirname(os.path.abspath(__file__))
    if hasattr(psycopg2, '__libpq_version__') and psycopg2.__libpq_version__ < 100000:
        return psycopg2.connect(dbname = cfg['db'], user = cfg['user'], password = cfg['passwd'], host = cfg['host'], port = cfg['port'], sslmode = 'verify-full', sslrootcert = '%s/.pgsql/root.crt' % CURDIR, target_session_attrs = ('read-write' if mode == 'read-write' else 'any'))
    else:
        if ',' in cfg['host']:
            for host in cfg['host'].split(','):
                try:
                    pg = psycopg2.connect(database = cfg['db'], user = cfg['user'], password = cfg['passwd'], host = host, port = cfg['port'], sslmode = 'verify-full', sslrootcert = '%s/.pgsql/root.crt' % CURDIR)
                    pg_cursor = pg.cursor()
                    pg_cursor.execute("SELECT pg_is_in_recovery()")
                    res = pg_cursor.fetchone()
                    pg_cursor.close()
                    if res and (mode == 'read-write' and not res[0] or mode != 'read-write' and res[0]):
                        return pg
                except Exception, e:
                    loggerFS.error("getPGdb exception: %s" % str(e), True)
                    continue
        else:
            return psycopg2.connect(database = cfg['db'], user = cfg['user'], password = cfg['passwd'], host = cfg['host'], port = cfg['port'], sslmode = 'verify-full', sslrootcert = '%s/.pgsql/root.crt' % CURDIR)
    return None

def sendEmail(msg, fromaddr = CFG['robot'], toaddr = CFG['report']):
    try:
        if toaddr:
            server = SMTP(CFG['smtp_host'], CFG['smtp_port'], timeout = CFG['smtp_timeout'])
            server.sendmail(fromaddr, toaddr, msg)
            server.quit()
        else:
            writelog("Sending email failed: to-addr must be set!")
    except Exception, e:
        loggerFS.error("Error in sendEmail: %s" % str(e), True)

