# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import psycopg2, time
import psycopg2.errorcodes
from common import *

def revive_connection(self, errmsg = '', ifHasCursor = False):
    if not self._db or (hasattr(self._db, 'closed') and self._db.closed) or errmsg.find('server conn crashed') > -1 or errmsg.find('connection has been closed') > -1:
        if ifHasCursor:
            self._db.connect()
        else:
            self.connect()
    if ifHasCursor and (not hasattr(self, 'cursor') or not self.cursor or self._cursor.closed):
        self._cursor = self._db.cursor()

def cursor_proxy(attempts_cnt = 1):
    def decorator_cursor_proxy(op):
        def pg_operation_wrapper(self, *args, **kwargs):
            i, errmsg = 0, 'Unknown'
            while i < attempts_cnt:
                try:
                    return op(self, *args, **kwargs)
                except psycopg2.DatabaseError, e:
                    errmsg = "PGCursorProxy %s psycopg2.DatabaseError (%s): %s" % (op.__name__, e.pgcode, str(e))
                    if e.pgcode == '23505': # unique_violation
                        break
                    elif str(e) == 'no results to fetch':
                        return None
                    loggerFLP.error(errmsg, True)
                except Exception, e:
                    #errmsg = "PGCursorProxy %s exception: %s\nParameters: %s" % (op.__name__, str(e), args)
                    errmsg = "PGCursorProxy %s exception: %s" % (op.__name__, str(e))
                    loggerFLP.error(errmsg, True)
                revive_connection(self, errmsg, True)
                i += 1
                loggerFLP.trace("PGCursorProxy %s: %d attempt" % (op.__name__, i))
            raise Exception(errmsg)
        return pg_operation_wrapper
    return decorator_cursor_proxy

def proxy(attempts_cnt = 1):
    def decorator_proxy(op):
        def pg_operation_wrapper(self, *args, **kwargs):
            i, errmsg = 0, 'Unknown'
            while i < attempts_cnt:
                try:
                    return op(self, *args, **kwargs)
                except psycopg2.DatabaseError, e:
                    errmsg = "PGProxy %s psycopg2.DatabaseError (%s): %s" % (op.__name__, e.pgcode, str(e))
                    if e.pgcode == '23505': # unique_violation
                        break
                    loggerFLP.error(errmsg, True)
                except Exception, e:
                    errmsg = "PGProxy %s exception: %s" % (op.__name__, str(e))
                    loggerFLP.error(errmsg, True)
                revive_connection(self, errmsg)
                i += 1
                loggerFLP.trace("PGProxy %s: %d attempt" % (op.__name__, i))
            raise Exception(errmsg)
        return pg_operation_wrapper
    return decorator_proxy

class PGCursorProxy:
    def __init__(self, db, cursor):
        self._cursor = cursor
        self._db = db

    def closed(self):
        return self._cursor.closed

    @cursor_proxy()
    def execute(self, q, args = None):
        return self._cursor.execute(q, args)

    @cursor_proxy()
    def executemany(self, q, args):
        return self._cursor.executemany(q, args)

    @cursor_proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def fetchall(self):
        return self._cursor.fetchall()

    @cursor_proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def fetchone(self):
        return self._cursor.fetchone()

    @cursor_proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def fetchmany(self):
        return self._cursor.fetchmany()

    @cursor_proxy()
    def executeAndFetchOne(self, q):
        self._cursor.execute(q)
        return self._cursor.fetchone()

    def close(self):
        try:
            return self._cursor.close()
        except Exception, e:
            pass

class PGProxy:
    def __init__(self, host, port, user, passwd, db, charset):
        self._params = { "host": host, "port": port, "user": user, "passwd": passwd, "db": db, "charset": charset }
        self.connect()

    @proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def _connect(self, host, port, user, passwd, db, charset):
        self._db = getPGdb(PG)
        return self._db

    def connect(self):
        return self._connect(**self._params)

    @proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def cursor(self):
        return PGCursorProxy(self._db, self._db.cursor())

    @proxy(MAX_DB_CONNECTION_ATTEMPTS)
    def cursorRaw(self):
        self.connect()
        return self._db.cursor()

    @proxy()
    def commit(self):
        return self._db.commit()
