#!/usr/bin/python -O
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys
from logreader import LogReader, MaskedFile
from sendanswerparser import SendAnswerParser
from deliveryparser import DeliveryParser
from clusterchecker import ClusterChecker
from statisticsdb import Database
from datetime import datetime

PIDFILE = "/var/run/frodo_logparse.pid"
LOGFILE = '/var/log/so-logs/frodo_logparse.log'

from common import *
from daemonize import become_daemon

if len(sys.argv) == 1:
    N, follow = 0, True
else:
    N = (datetime.today() - datetime.strptime(sys.argv[1], "%d-%m-%Y")).days
    if len(sys.argv) >= 3:
        follow = sys.argv[2].lower() == "follow"
    else:
        follow = False
try:
    if follow:
        become_daemon()
        writePid(PIDFILE)
    db = Database()
    reader = LogReader(db, follow)
    id_delivery = reader.addLog(MaskedFile(DELIVERY_LOG_MASK, N))
    id_sendanswer = reader.addLog(MaskedFile(SENDANSWER_LOG_MASK, N))
    reader.addParser(id_delivery, DeliveryParser(db, PARSE_PERIOD))
    reader.addParser(id_delivery, ClusterChecker(db, PARSE_PERIOD))
    reader.addParser(id_sendanswer, SendAnswerParser(db, PARSE_PERIOD))
    reader.process()
except Exception, e:
    loggerFLP.error("Exception in a top level: %s" % str(e), True)
